/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.print;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.composite.DependencyDescriptor;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.object.ObjectDescriptor;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.envisage.graph.GraphDisplay;
import org.qi4j.envisage.print.PrintingException;
import org.qi4j.envisage.util.TableRow;
import org.qi4j.envisage.util.TableRowUtilities;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.CompositeDetailDescriptor;
import org.qi4j.tools.model.descriptor.CompositeMethodDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.ImportedServiceCompositeDescriptor;
import org.qi4j.tools.model.descriptor.ImportedServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.InjectedFieldDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.MixinDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.TransientDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorUtilities;

public class PDFWriter {
    protected PDDocument doc = null;
    protected PDPageContentStream curContentStream = null;
    protected PDRectangle curPageSize;
    protected float curY;
    protected PDFont curFont;
    protected float curFontSize;
    protected String APPLICATION = "Application";
    protected String LAYER = "Layer";
    protected String MODULE = "Module";
    protected PDFont normalFont = PDType1Font.HELVETICA;
    protected PDFont header1Font = PDType1Font.HELVETICA_BOLD;
    protected PDFont header2Font = PDType1Font.HELVETICA_BOLD;
    protected PDFont header3Font = PDType1Font.HELVETICA_BOLD;
    protected PDFont header4Font = PDType1Font.HELVETICA_BOLD;
    protected PDFont header5Font = PDType1Font.HELVETICA_BOLD_OBLIQUE;
    protected float normalFontSize = 10.0f;
    protected float header1FontSize = 18.0f;
    protected float header2FontSize = 16.0f;
    protected float header3FontSize = 14.0f;
    protected float header4FontSize = 12.0f;
    protected float header5FontSize = 12.0f;
    protected float startX = 40.0f;
    protected float startY = 40.0f;
    protected float lineSpace = 15.0f;
    protected float headerLineSpace = 25.0f;

    public void write(Component parent, ApplicationDetailDescriptor descriptor, List<GraphDisplay> graphDisplays) {
        String ext;
        JFileChooser fc = new JFileChooser();
        PDFFileFilter pdfFileFilter = new PDFFileFilter();
        fc.setFileFilter(pdfFileFilter);
        int choice = fc.showSaveDialog(parent);
        if (choice != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        String filename = file.toString();
        if (!filename.endsWith(ext = ".pdf")) {
            filename = filename + ext;
            file = new File(filename);
        }
        this.write(file, descriptor, graphDisplays);
    }

    public void write(File file, ApplicationDetailDescriptor descriptor, List<GraphDisplay> graphDisplays) {
        try {
            this.writeImpl(file, descriptor, graphDisplays);
        }
        catch (IOException | COSVisitorException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeImpl(File file, ApplicationDetailDescriptor descriptor, List<GraphDisplay> graphDisplays) throws IOException, COSVisitorException {
        try {
            this.doc = new PDDocument();
            for (GraphDisplay graphDisplay : graphDisplays) {
                this.writeGraphPage(graphDisplay);
            }
            this.writePage(descriptor);
            if (this.curContentStream != null) {
                this.curContentStream.close();
                this.curContentStream = null;
            }
            this.doc.save((OutputStream)new FileOutputStream(file));
        }
        finally {
            if (this.curContentStream != null) {
                this.curContentStream.close();
                this.curContentStream = null;
            }
            if (this.doc != null) {
                this.doc.close();
                this.doc = null;
            }
        }
    }

    private void writeGraphPage(GraphDisplay graphDisplay) throws IOException {
        File tFile = File.createTempFile("envisage", "png");
        graphDisplay.saveImage(new FileOutputStream(tFile), "png", 1.0);
        BufferedImage img = ImageIO.read(tFile);
        int w = img.getWidth();
        int h = img.getHeight();
        int inset = 40;
        PDRectangle pdRect = new PDRectangle((float)(w + inset), (float)(h + inset));
        PDPage page = new PDPage();
        page.setMediaBox(pdRect);
        this.doc.addPage(page);
        PDJpeg xImage = new PDJpeg(this.doc, img);
        PDPageContentStream contentStream = new PDPageContentStream(this.doc, page);
        contentStream.drawImage((PDXObjectImage)xImage, (pdRect.getWidth() - (float)w) / 2.0f, (pdRect.getHeight() - (float)h) / 2.0f);
        contentStream.close();
    }

    private void writePage(ApplicationDetailDescriptor descriptor) {
        this.createNewPage();
        this.setFont(this.header1Font, this.header1FontSize);
        this.writeString(this.APPLICATION + " : " + descriptor.toString());
        this.writeLayersPage(descriptor.layers());
    }

    private void writeLayersPage(Iterable<LayerDetailDescriptor> iter) {
        for (LayerDetailDescriptor descriptor : iter) {
            this.setFont(this.header2Font, this.header2FontSize);
            this.writeString(this.LAYER + " : " + descriptor.toString(), this.headerLineSpace);
            this.writeModulesPage(descriptor.modules());
        }
    }

    private void writeModulesPage(Iterable<ModuleDetailDescriptor> iter) {
        for (ModuleDetailDescriptor descriptor : iter) {
            this.setFont(this.header3Font, this.header3FontSize);
            this.writeString(this.MODULE + " : " + descriptor.toString(), this.headerLineSpace);
            this.writeServicesPage(descriptor.services());
            this.writeImportedServicesPage(descriptor.importedServices());
            this.writeEntitiesPage(descriptor.entities());
            this.writeTransientsPage(descriptor.transients());
            this.writeValuesPage(descriptor.values());
            this.writeObjectsPage(descriptor.objects());
        }
    }

    private void writeServicesPage(Iterable<ServiceDetailDescriptor> iter) {
        for (ServiceDetailDescriptor descriptor : iter) {
            this.setFont(this.header4Font, this.header4FontSize);
            this.writeString(descriptor.toString(), this.headerLineSpace);
            this.writeTypeGeneralPage(descriptor);
            this.writeTypeDependenciesPage(descriptor);
            this.writeTypeMethodsPage(descriptor);
            this.writeTypeStatesPage(descriptor);
            this.writeTypeServiceConfigurationPage(descriptor);
            this.writeTypeServiceUsagePage(descriptor);
        }
    }

    private void writeImportedServicesPage(Iterable<ImportedServiceDetailDescriptor> iter) {
        for (ImportedServiceDetailDescriptor descriptor : iter) {
            this.setFont(this.header4Font, this.header4FontSize);
            this.writeString(descriptor.toString(), this.headerLineSpace);
            this.writeTypeGeneralPage(descriptor);
            this.writeTypeMethodsPage(descriptor);
            this.writeTypeServiceUsagePage(descriptor);
            this.writeTypeImportedByPage(descriptor);
        }
    }

    private void writeEntitiesPage(Iterable<EntityDetailDescriptor> iter) {
        for (EntityDetailDescriptor descriptor : iter) {
            this.setFont(this.header4Font, this.header4FontSize);
            this.writeString(descriptor.toString(), this.headerLineSpace);
            this.writeTypeGeneralPage(descriptor);
            this.writeTypeDependenciesPage(descriptor);
            this.writeTypeMethodsPage(descriptor);
            this.writeTypeStatesPage(descriptor);
        }
    }

    private void writeTransientsPage(Iterable<TransientDetailDescriptor> iter) {
        for (TransientDetailDescriptor descriptor : iter) {
            this.setFont(this.header4Font, this.header4FontSize);
            this.writeString(descriptor.toString(), this.headerLineSpace);
            this.writeTypeGeneralPage(descriptor);
            this.writeTypeDependenciesPage(descriptor);
            this.writeTypeMethodsPage(descriptor);
            this.writeTypeStatesPage(descriptor);
        }
    }

    private void writeValuesPage(Iterable<ValueDetailDescriptor> iter) {
        for (ValueDetailDescriptor descriptor : iter) {
            this.setFont(this.header4Font, this.header4FontSize);
            this.writeString(descriptor.toString(), this.headerLineSpace);
            this.writeTypeGeneralPage(descriptor);
            this.writeTypeDependenciesPage(descriptor);
            this.writeTypeMethodsPage(descriptor);
            this.writeTypeStatesPage(descriptor);
        }
    }

    private void writeObjectsPage(Iterable<ObjectDetailDescriptor> iter) {
        for (ObjectDetailDescriptor descriptor : iter) {
            this.setFont(this.header4Font, this.header4FontSize);
            this.writeString(descriptor.toString(), this.headerLineSpace);
            this.writeTypeGeneralPage(descriptor);
            this.writeTypeDependenciesPage(descriptor);
        }
    }

    private void writeTypeGeneralPage(Object objectDesciptor) {
        this.setFont(this.header5Font, this.header5FontSize);
        this.writeString("General: ", this.headerLineSpace);
        this.setFont(this.normalFont, this.normalFontSize);
        if (objectDesciptor instanceof ServiceDetailDescriptor) {
            ServiceDescriptor descriptor = (ServiceDescriptor)((ServiceDetailDescriptor)objectDesciptor).descriptor();
            this.writeString("- identity: " + descriptor.identity());
            this.writeString("- class: " + descriptor.toString());
            this.writeString("- visibility: " + descriptor.visibility().toString());
            this.writeString("- startup: " + ((ServiceDescriptor)((ServiceDetailDescriptor)objectDesciptor).descriptor()).isInstantiateOnStartup());
        } else if (objectDesciptor instanceof EntityDetailDescriptor) {
            EntityDescriptor descriptor = (EntityDescriptor)((EntityDetailDescriptor)objectDesciptor).descriptor();
            this.writeString("- name: " + descriptor.toString());
            this.writeString("- class: " + descriptor.toString());
            this.writeString("- visibility: " + descriptor.visibility().toString());
        } else if (objectDesciptor instanceof ValueDetailDescriptor) {
            ValueDescriptor descriptor = (ValueDescriptor)((ValueDetailDescriptor)objectDesciptor).descriptor();
            this.writeString("- name: " + descriptor.toString());
            this.writeString("- class: " + descriptor.toString());
            this.writeString("- visibility: " + descriptor.visibility().toString());
        } else if (objectDesciptor instanceof ObjectDetailDescriptor) {
            ObjectDescriptor descriptor = ((ObjectDetailDescriptor)objectDesciptor).descriptor();
            this.writeString("- name: " + descriptor.toString());
            this.writeString("- class: " + descriptor.toString());
            this.writeString("- visibility: " + descriptor.visibility().toString());
        } else if (objectDesciptor instanceof CompositeDetailDescriptor) {
            CompositeDescriptor descriptor = ((CompositeDetailDescriptor)objectDesciptor).descriptor();
            this.writeString("- name: " + descriptor.toString());
            this.writeString("- class: " + descriptor.toString());
            this.writeString("- visibility: " + descriptor.visibility().toString());
        }
    }

    private void writeTypeDependenciesPage(Object objectDesciptor) {
        this.setFont(this.header5Font, this.header5FontSize);
        this.writeString("Dependencies: ", this.headerLineSpace);
        if (objectDesciptor instanceof CompositeDetailDescriptor) {
            CompositeDetailDescriptor descriptor = (CompositeDetailDescriptor)objectDesciptor;
            Iterable iter = descriptor.mixins();
            for (MixinDetailDescriptor mixinDescriptor : iter) {
                this.writeTypeDependenciesPage(mixinDescriptor.injectedFields());
            }
        } else if (objectDesciptor instanceof ObjectDetailDescriptor) {
            ObjectDetailDescriptor descriptor = (ObjectDetailDescriptor)objectDesciptor;
            this.writeTypeDependenciesPage(descriptor.injectedFields());
        }
    }

    private void writeTypeDependenciesPage(Iterable<InjectedFieldDetailDescriptor> iter) {
        this.setFont(this.normalFont, this.normalFontSize);
        for (InjectedFieldDetailDescriptor descriptor : iter) {
            DependencyDescriptor dependencyDescriptor = descriptor.descriptor().dependency();
            this.writeString("- name: " + dependencyDescriptor.injectedClass().getSimpleName());
            this.writeString("    * annotation: @" + dependencyDescriptor.injectionAnnotation().annotationType().getSimpleName());
            this.writeString("    * optional: " + Boolean.toString(dependencyDescriptor.optional()));
            this.writeString("    * type: " + dependencyDescriptor.injectionType().getClass().getSimpleName());
        }
    }

    private void writeTypeMethodsPage(Object objectDesciptor) {
        if (!CompositeDetailDescriptor.class.isAssignableFrom(objectDesciptor.getClass())) {
            return;
        }
        this.setFont(this.header5Font, this.header5FontSize);
        this.writeString("Methods: ", this.headerLineSpace);
        this.setFont(this.normalFont, this.normalFontSize);
        CompositeDetailDescriptor descriptor = (CompositeDetailDescriptor)objectDesciptor;
        List list = DescriptorUtilities.findMethod((CompositeDetailDescriptor)descriptor);
        HashSet<String> imports = new HashSet<String>();
        for (CompositeMethodDetailDescriptor methodDescriptor : list) {
            this.addImport(imports, methodDescriptor.descriptor().method().getGenericReturnType());
            for (Class<?> parameter : methodDescriptor.descriptor().method().getParameterTypes()) {
                this.addImport(imports, parameter);
            }
        }
        for (String imp : imports) {
            this.writeString("    import " + imp + ";");
        }
        this.writeString("");
        for (CompositeMethodDetailDescriptor methodDescriptor : list) {
            Type returnType = methodDescriptor.descriptor().method().getGenericReturnType();
            this.writeString("    " + this.formatType(returnType) + "." + methodDescriptor.toString() + this.formatParameters(methodDescriptor.descriptor().method().getParameterTypes()));
        }
    }

    private String formatParameters(Class<?>[] parameterTypes) {
        StringBuilder result = new StringBuilder();
        result.append("(");
        boolean first = true;
        int count = 1;
        for (Class<?> parameter : parameterTypes) {
            if (!first) {
                result.append(",");
            }
            first = false;
            result.append(" ");
            result.append(this.formatType(parameter));
            result.append(" ");
            result.append("p");
            result.append(count++);
        }
        if (first) {
            result.append(");");
        } else {
            result.append(" );");
        }
        return result.toString();
    }

    private String formatType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] actuals = pType.getActualTypeArguments();
            Type ownerType = pType.getOwnerType();
            Type rawType = pType.getRawType();
            StringBuilder result = new StringBuilder();
            result.append(((Class)rawType).getSimpleName());
            result.append("<");
            boolean first = true;
            for (Type actual : actuals) {
                if (!first) {
                    result.append(",");
                }
                first = false;
                result.append(this.formatType(actual));
            }
            result.append(">");
            return result.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            Type[] lowers = wildcard.getLowerBounds();
            Type[] uppers = wildcard.getUpperBounds();
            StringBuilder result = new StringBuilder();
            result.append("? extends ");
            boolean first = true;
            for (Type upper : uppers) {
                if (!first) {
                    result.append(", ");
                }
                result.append(this.formatType(upper));
            }
            return result.toString();
        }
        if (type instanceof TypeVariable) {
            return type.toString();
        }
        return type.toString();
    }

    private void addImport(HashSet<String> imports, Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            Package pkkage = clazz.getPackage();
            if (pkkage == null) {
                return;
            }
            String packageName = pkkage.getName();
            if (packageName.startsWith("java")) {
                return;
            }
            imports.add(clazz.getName());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] actuals = pType.getActualTypeArguments();
            Type ownerType = pType.getOwnerType();
            Type rawType = pType.getRawType();
            this.addImport(imports, ownerType);
            this.addImport(imports, rawType);
            for (Type actual : actuals) {
                this.addImport(imports, actual);
            }
        }
    }

    private void writeTypeStatesPage(Object objectDesciptor) {
        if (!CompositeDetailDescriptor.class.isAssignableFrom(objectDesciptor.getClass())) {
            return;
        }
        this.setFont(this.header5Font, this.header5FontSize);
        this.writeString("States: ", this.headerLineSpace);
        CompositeDetailDescriptor descriptor = (CompositeDetailDescriptor)objectDesciptor;
        List list = DescriptorUtilities.findState((CompositeDetailDescriptor)descriptor);
        this.setFont(this.normalFont, this.normalFontSize);
        for (CompositeMethodDetailDescriptor methodDescriptor : list) {
            this.writeString("- name: " + methodDescriptor.toString());
            this.writeString("    * return: " + methodDescriptor.descriptor().method().getGenericReturnType());
        }
    }

    private void writeTypeServiceConfigurationPage(Object objectDesciptor) {
        String typeString;
        CompositeDescriptor spiDescriptor;
        this.setFont(this.header5Font, this.header5FontSize);
        this.writeString("Configuration: ", this.headerLineSpace);
        Object configDescriptor = DescriptorUtilities.findServiceConfiguration((ServiceDetailDescriptor)((ServiceDetailDescriptor)objectDesciptor));
        if (configDescriptor == null) {
            return;
        }
        if (configDescriptor instanceof ServiceDetailDescriptor) {
            spiDescriptor = ((ServiceDetailDescriptor)configDescriptor).descriptor();
            typeString = "Service";
        } else if (configDescriptor instanceof EntityDetailDescriptor) {
            spiDescriptor = ((EntityDetailDescriptor)configDescriptor).descriptor();
            typeString = "Entity";
        } else if (configDescriptor instanceof ValueDetailDescriptor) {
            spiDescriptor = ((ValueDetailDescriptor)configDescriptor).descriptor();
            typeString = "Value";
        } else if (configDescriptor instanceof ObjectDetailDescriptor) {
            spiDescriptor = ((ObjectDetailDescriptor)configDescriptor).descriptor();
            typeString = "Object";
        } else if (configDescriptor instanceof CompositeDetailDescriptor) {
            spiDescriptor = ((CompositeDetailDescriptor)configDescriptor).descriptor();
            typeString = "Transient";
        } else {
            throw new PrintingException("Unknown configuration descriptor: " + configDescriptor.getClass().getName(), null);
        }
        this.setFont(this.normalFont, this.normalFontSize);
        this.writeString("- name: " + spiDescriptor.toString());
        this.writeString("- class: " + spiDescriptor.toString());
        this.writeString("- type: " + typeString);
    }

    private void writeTypeServiceUsagePage(Object objectDesciptor) {
        this.setFont(this.header5Font, this.header5FontSize);
        this.writeString("Usage: ", this.headerLineSpace);
        this.setFont(this.normalFont, this.normalFontSize);
        List serviceUsages = DescriptorUtilities.findServiceUsage((ServiceDetailDescriptor)((ServiceDetailDescriptor)objectDesciptor));
        List<TableRow> rows = TableRowUtilities.toTableRows(serviceUsages);
        for (TableRow row : rows) {
            String layer;
            String module;
            CompositeDetailDescriptor descriptor;
            Object obj = row.get(0);
            if (obj instanceof CompositeDetailDescriptor) {
                descriptor = (CompositeDetailDescriptor)obj;
                module = descriptor.module().toString();
                layer = descriptor.module().layer().toString();
            } else {
                descriptor = (ObjectDetailDescriptor)obj;
                module = descriptor.module().toString();
                layer = descriptor.module().layer().toString();
            }
            InjectedFieldDetailDescriptor injectedFieldescriptor = (InjectedFieldDetailDescriptor)row.get(1);
            DependencyDescriptor dependencyDescriptor = injectedFieldescriptor.descriptor().dependency();
            Annotation annotation = dependencyDescriptor.injectionAnnotation();
            String usage = injectedFieldescriptor.toString() + " (@" + annotation.annotationType().getSimpleName() + ")";
            this.writeString("- owner: " + row.get(0).toString());
            this.writeString("    * usage: " + usage);
            this.writeString("    * module: " + module);
            this.writeString("    * layer: " + layer);
        }
    }

    private void writeTypeImportedByPage(Object objectDesciptor) {
        this.setFont(this.header5Font, this.header5FontSize);
        this.writeString("Imported by: ", this.headerLineSpace);
        ImportedServiceDetailDescriptor detailDescriptor = (ImportedServiceDetailDescriptor)objectDesciptor;
        ImportedServiceDescriptor descriptor = ((ImportedServiceCompositeDescriptor)detailDescriptor.descriptor()).importedService();
        Class importer = descriptor.serviceImporter();
        this.setFont(this.normalFont, this.normalFontSize);
        this.writeString("- name: " + importer.getSimpleName());
        this.writeString("- class: " + importer.toString());
    }

    private void writeString(String text) {
        this.writeString(text, this.lineSpace);
    }

    private void writeString(String text, float lineSpace) {
        if (this.curY - lineSpace <= this.startY) {
            this.createNewPage();
        }
        this.curY -= lineSpace;
        try {
            this.curContentStream.moveTextPositionByAmount(0.0f, -lineSpace);
            this.curContentStream.drawString(text);
        }
        catch (IOException e) {
            throw new PrintingException("Unable to write string: " + text, e);
        }
    }

    private void setFont(PDFont font, float fontSize) {
        this.curFont = font;
        this.curFontSize = fontSize;
        try {
            this.curContentStream.setFont(this.curFont, this.curFontSize);
        }
        catch (IOException e) {
            throw new PrintingException("Unable to set font: " + font.toString() + ", " + fontSize + "pt", e);
        }
    }

    private void createNewPage() {
        try {
            if (this.curContentStream != null) {
                this.curContentStream.endText();
                this.curContentStream.close();
            }
            PDPage page = new PDPage();
            this.doc.addPage(page);
            this.curContentStream = new PDPageContentStream(this.doc, page);
            this.curPageSize = page.getArtBox();
            this.curContentStream.beginText();
            this.curY = this.curPageSize.getHeight() - this.startY;
            this.curContentStream.moveTextPositionByAmount(this.startX, this.curY);
            if (this.curFont != null) {
                this.setFont(this.curFont, this.curFontSize);
            }
        }
        catch (IOException e) {
            throw new PrintingException("Unable to create page.", e);
        }
    }

    private double scaleToFit(double srcW, double srcH, double destW, double destH) {
        double scale = 1.0;
        if (srcW > srcH) {
            if (srcW > destW) {
                scale = destW / srcW;
            }
            if ((srcH *= scale) > destH) {
                scale *= destH / srcH;
            }
        } else {
            if (srcH > destH) {
                scale = destH / srcH;
            }
            if ((srcW *= scale) > destW) {
                scale *= destW / srcW;
            }
        }
        return scale;
    }

    static class PDFFileFilter
    extends FileFilter {
        private final String description;
        protected String extension = "pdf";

        public PDFFileFilter() {
            this.description = "PDF - Portable Document Format";
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String str = this.getExtension(f);
                if (str != null && str.equals(this.extension)) {
                    return true;
                }
            }
            return false;
        }

        public String getExtension(File f) {
            String filename;
            int i;
            if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                return filename.substring(i + 1).toLowerCase();
            }
            return null;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

