/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.ImportedServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.TransientDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorNameComparator;

final class StructureModelBuilder {
    private final DescriptorNameComparator<Object> nameComparator = new DescriptorNameComparator();
    private final List<Object> tempList = new ArrayList<Object>();

    StructureModelBuilder() {
    }

    static MutableTreeNode build(ApplicationDetailDescriptor descriptor) {
        StructureModelBuilder builder = new StructureModelBuilder();
        return builder.buildApplicationNode(descriptor);
    }

    private MutableTreeNode buildApplicationNode(ApplicationDetailDescriptor descriptor) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(descriptor);
        this.buildLayersNode(node, descriptor.layers());
        return node;
    }

    private void buildLayersNode(DefaultMutableTreeNode parent, Iterable<LayerDetailDescriptor> iter) {
        for (LayerDetailDescriptor descriptor : iter) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(descriptor);
            this.buildModulesNode(node, descriptor.modules());
            parent.add(node);
        }
    }

    private void buildModulesNode(DefaultMutableTreeNode parent, Iterable<ModuleDetailDescriptor> iter) {
        for (ModuleDetailDescriptor descriptor : iter) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(descriptor);
            this.buildServicesNode(node, descriptor.services());
            this.buildImportedServicesNode(node, descriptor.importedServices());
            this.buildEntitiesNode(node, descriptor.entities());
            this.buildTransientsNode(node, descriptor.transients());
            this.buildValuesNode(node, descriptor.values());
            this.buildObjectsNode(node, descriptor.objects());
            parent.add(node);
        }
    }

    private void addTypeChildren(DefaultMutableTreeNode parent, List<Object> childList) {
        Collections.sort(childList, this.nameComparator);
        for (int i = 0; i < childList.size(); ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(childList.get(i));
            parent.add(node);
        }
    }

    private void buildServicesNode(DefaultMutableTreeNode parent, Iterable<ServiceDetailDescriptor> iter) {
        this.tempList.clear();
        for (ServiceDetailDescriptor descriptor : iter) {
            this.tempList.add(descriptor);
        }
        this.addTypeChildren(parent, this.tempList);
    }

    private void buildImportedServicesNode(DefaultMutableTreeNode parent, Iterable<ImportedServiceDetailDescriptor> iter) {
        this.tempList.clear();
        for (ImportedServiceDetailDescriptor descriptor : iter) {
            this.tempList.add(descriptor);
        }
        this.addTypeChildren(parent, this.tempList);
    }

    private void buildEntitiesNode(DefaultMutableTreeNode parent, Iterable<EntityDetailDescriptor> iter) {
        this.tempList.clear();
        for (EntityDetailDescriptor descriptor : iter) {
            this.tempList.add(descriptor);
        }
        this.addTypeChildren(parent, this.tempList);
    }

    private void buildTransientsNode(DefaultMutableTreeNode parent, Iterable<TransientDetailDescriptor> iter) {
        this.tempList.clear();
        for (TransientDetailDescriptor descriptor : iter) {
            this.tempList.add(descriptor);
        }
        this.addTypeChildren(parent, this.tempList);
    }

    private void buildValuesNode(DefaultMutableTreeNode parent, Iterable<ValueDetailDescriptor> iter) {
        this.tempList.clear();
        for (ValueDetailDescriptor descriptor : iter) {
            this.tempList.add(descriptor);
        }
        this.addTypeChildren(parent, this.tempList);
    }

    private void buildObjectsNode(DefaultMutableTreeNode parent, Iterable<ObjectDetailDescriptor> iter) {
        this.tempList.clear();
        for (ObjectDetailDescriptor descriptor : iter) {
            this.tempList.add(descriptor);
        }
        this.addTypeChildren(parent, this.tempList);
    }
}

