/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.tree;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.qi4j.envisage.tree.StructureModelBuilder;
import org.qi4j.envisage.tree.TreeModelCellRenderer;
import org.qi4j.envisage.tree.TypeModelBuilder;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;

public final class TreeModelPane
extends JPanel {
    private static final String STRUCTURE_VIEW = "Structure";
    private static final String TYPE_VIEW = "Type";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(TreeModelPane.class.getName());
    private JPanel mainPane;
    private CardLayout cardLayout;
    private JTree structureTree;
    private JTree typeTree;
    private JComboBox viewAsCombo;
    private boolean selectionInProgress;

    public TreeModelPane() {
        this.setLayout(new BorderLayout());
        this.structureTree = new JTree();
        this.structureTree.setRootVisible(false);
        this.structureTree.setShowsRootHandles(true);
        this.structureTree.setExpandsSelectedPaths(true);
        this.structureTree.setScrollsOnExpand(true);
        this.structureTree.setName(STRUCTURE_VIEW);
        this.structureTree.setCellRenderer(new TreeModelCellRenderer());
        this.typeTree = new JTree();
        this.typeTree.setRootVisible(false);
        this.typeTree.setShowsRootHandles(true);
        this.typeTree.setExpandsSelectedPaths(true);
        this.typeTree.setScrollsOnExpand(true);
        this.typeTree.setName(TYPE_VIEW);
        this.typeTree.setCellRenderer(new TreeModelCellRenderer());
        this.mainPane = new JPanel();
        this.cardLayout = new CardLayout();
        this.mainPane.setLayout(this.cardLayout);
        this.mainPane.add((Component)new JScrollPane(this.structureTree), STRUCTURE_VIEW);
        this.mainPane.add((Component)new JScrollPane(this.typeTree), TYPE_VIEW);
        this.add((Component)this.mainPane, "Center");
        JPanel viewAsPane = new JPanel();
        viewAsPane.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 0));
        viewAsPane.setLayout(new GridBagLayout());
        JLabel viewAsLabel = new JLabel(BUNDLE.getString("CTL_ViewAs.Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        viewAsPane.add((Component)viewAsLabel, gridBagConstraints);
        this.viewAsCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{STRUCTURE_VIEW, TYPE_VIEW}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        viewAsPane.add((Component)this.viewAsCombo, gridBagConstraints);
        this.viewAsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                TreeModelPane.this.cardLayout.show(TreeModelPane.this.mainPane, evt.getItem().toString());
                TreeModelPane.this.repaint();
            }
        });
        this.add((Component)viewAsPane, "First");
    }

    public void initQi4J(ApplicationDetailDescriptor descriptor) {
        MutableTreeNode rootNode1 = StructureModelBuilder.build(descriptor);
        MutableTreeNode rootNode2 = TypeModelBuilder.build(descriptor);
        this.structureTree.setModel(new DefaultTreeModel(rootNode1));
        this.typeTree.setModel(new DefaultTreeModel(rootNode2));
        this.structureTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreeModelPane.this.structureTreeValueChanged();
            }
        });
        this.typeTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreeModelPane.this.typeTreeValueChanged();
            }
        });
    }

    public Object getLastSelected() {
        Object obj = this.structureTree.getLastSelectedPathComponent();
        if (obj != null) {
            return ((DefaultMutableTreeNode)obj).getUserObject();
        }
        return null;
    }

    public void setSelectedValue(Object obj) {
        if (obj == null) {
            return;
        }
        TreeNode node = this.findNode(this.structureTree, obj);
        if (node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.structureTree.getModel();
            TreePath treePath = new TreePath(treeModel.getPathToRoot(node));
            this.structureTree.setSelectionPath(treePath);
            this.structureTree.scrollPathToVisible(treePath);
        } else {
            this.structureTree.clearSelection();
        }
    }

    protected TreeNode findNode(JTree tree, Object object) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        return this.findNode(node, object);
    }

    private TreeNode findNode(DefaultMutableTreeNode node, Object obj) {
        DefaultMutableTreeNode childNode;
        if (obj instanceof String ? node.getUserObject().toString().equals(obj.toString()) : node.getUserObject().equals(obj)) {
            return node;
        }
        TreeNode foundNode = null;
        for (int i = 0; i < node.getChildCount() && (foundNode = this.findNode(childNode = (DefaultMutableTreeNode)node.getChildAt(i), obj)) == null; ++i) {
        }
        return foundNode;
    }

    public final void addTreeSelectionListener(TreeSelectionListener listener) {
        this.structureTree.addTreeSelectionListener(listener);
    }

    public final void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.structureTree.removeTreeSelectionListener(listener);
    }

    protected void structureTreeValueChanged() {
        if (this.selectionInProgress) {
            return;
        }
        Object userObject = this.getLastSelected();
        if (userObject == null) {
            return;
        }
        TreeNode node = this.findNode(this.typeTree, userObject);
        if (node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.typeTree.getModel();
            TreePath treePath = new TreePath(treeModel.getPathToRoot(node));
            this.typeTree.setSelectionPath(treePath);
            this.typeTree.scrollPathToVisible(treePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void typeTreeValueChanged() {
        Object obj = this.typeTree.getLastSelectedPathComponent();
        if (obj == null) {
            return;
        }
        Object userObject = ((DefaultMutableTreeNode)obj).getUserObject();
        TreeNode node = this.findNode(this.structureTree, userObject);
        if (node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.structureTree.getModel();
            TreePath treePath = new TreePath(treeModel.getPathToRoot(node));
            this.selectionInProgress = true;
            try {
                this.structureTree.setSelectionPath(treePath);
            }
            finally {
                this.selectionInProgress = false;
            }
            this.structureTree.scrollPathToVisible(treePath);
        }
    }
}

