/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.envisage.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.ImportedServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.TransientDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;
import org.qi4j.tools.model.util.DescriptorNameComparator;

final class TypeModelBuilder {
    private final List<ServiceDetailDescriptor> serviceList = new ArrayList<ServiceDetailDescriptor>();
    private final List<ImportedServiceDetailDescriptor> importedServiceList = new ArrayList<ImportedServiceDetailDescriptor>();
    private final List<EntityDetailDescriptor> entityList = new ArrayList<EntityDetailDescriptor>();
    private final List<TransientDetailDescriptor> transientList = new ArrayList<TransientDetailDescriptor>();
    private final List<ValueDetailDescriptor> valueList = new ArrayList<ValueDetailDescriptor>();
    private final List<ObjectDetailDescriptor> objectList = new ArrayList<ObjectDetailDescriptor>();

    static MutableTreeNode build(ApplicationDetailDescriptor descriptor) {
        TypeModelBuilder builder = new TypeModelBuilder();
        return builder.buildNode(descriptor);
    }

    private TypeModelBuilder() {
    }

    private MutableTreeNode buildNode(ApplicationDetailDescriptor descriptor) {
        this.traverseLayers(descriptor.layers());
        DescriptorNameComparator nameComparator = new DescriptorNameComparator();
        Collections.sort(this.serviceList, nameComparator);
        Collections.sort(this.importedServiceList, nameComparator);
        Collections.sort(this.entityList, nameComparator);
        Collections.sort(this.transientList, nameComparator);
        Collections.sort(this.valueList, nameComparator);
        Collections.sort(this.objectList, nameComparator);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(descriptor);
        DefaultMutableTreeNode child = new DefaultMutableTreeNode("Services");
        this.addChild(child, this.serviceList);
        root.add(child);
        child = new DefaultMutableTreeNode("Imported Services");
        this.addChild(child, this.importedServiceList);
        root.add(child);
        child = new DefaultMutableTreeNode("Entities");
        this.addChild(child, this.entityList);
        root.add(child);
        child = new DefaultMutableTreeNode("Transients");
        this.addChild(child, this.transientList);
        root.add(child);
        child = new DefaultMutableTreeNode("Values");
        this.addChild(child, this.valueList);
        root.add(child);
        child = new DefaultMutableTreeNode("Objects");
        this.addChild(child, this.objectList);
        root.add(child);
        return root;
    }

    private void addChild(DefaultMutableTreeNode node, List list) {
        for (int i = 0; i < list.size(); ++i) {
            node.add(new DefaultMutableTreeNode(list.get(i)));
        }
    }

    private void traverseLayers(Iterable<LayerDetailDescriptor> iter) {
        for (LayerDetailDescriptor descriptor : iter) {
            this.traverseModules(descriptor.modules());
        }
    }

    private void traverseModules(Iterable<ModuleDetailDescriptor> iter) {
        for (ModuleDetailDescriptor descriptor : iter) {
            for (ServiceDetailDescriptor child : descriptor.services()) {
                this.serviceList.add(child);
            }
            for (ServiceDetailDescriptor child : descriptor.importedServices()) {
                this.importedServiceList.add((ImportedServiceDetailDescriptor)child);
            }
            for (ServiceDetailDescriptor child : descriptor.entities()) {
                this.entityList.add((EntityDetailDescriptor)child);
            }
            for (ServiceDetailDescriptor child : descriptor.transients()) {
                this.transientList.add((TransientDetailDescriptor)child);
            }
            for (ServiceDetailDescriptor child : descriptor.values()) {
                this.valueList.add((ValueDetailDescriptor)child);
            }
            for (ServiceDetailDescriptor child : descriptor.objects()) {
                this.objectList.add((ObjectDetailDescriptor)child);
            }
        }
    }
}

