/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.sql.dbcp;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.library.sql.datasource.AbstractDataSourceServiceImporterMixin;
import org.qi4j.library.sql.datasource.DataSourceConfigurationValue;
import org.qi4j.library.sql.datasource.DataSourceServiceImporterActivation;

@Mixins(value={Mixin.class})
@Activators(value={DataSourceServiceImporterActivation.Activator.class})
public interface DBCPDataSourceServiceImporter
extends ServiceImporter<DataSource>,
DataSourceServiceImporterActivation,
ServiceComposite {

    public static class Mixin
    extends AbstractDataSourceServiceImporterMixin<BasicDataSource> {
        protected BasicDataSource setupDataSourcePool(DataSourceConfigurationValue config) throws Exception {
            BasicDataSource pool = new BasicDataSource();
            Class.forName((String)config.driver().get());
            pool.setDriverClassName((String)config.driver().get());
            pool.setUrl((String)config.url().get());
            if (!((String)config.username().get()).equals("")) {
                pool.setUsername((String)config.username().get());
                pool.setPassword((String)config.password().get());
            }
            if (config.minPoolSize().get() != null) {
                pool.setMinIdle(((Integer)config.minPoolSize().get()).intValue());
            }
            if (config.maxPoolSize().get() != null) {
                pool.setMaxActive(((Integer)config.maxPoolSize().get()).intValue());
            }
            if (config.loginTimeoutSeconds().get() != null) {
                pool.setLoginTimeout(((Integer)config.loginTimeoutSeconds().get()).intValue());
            }
            if (config.maxConnectionAgeSeconds().get() != null) {
                pool.setMinEvictableIdleTimeMillis((long)((Integer)config.maxConnectionAgeSeconds().get() * 1000));
            }
            if (config.validationQuery().get() != null) {
                pool.setValidationQuery((String)config.validationQuery().get());
            }
            return pool;
        }

        protected void passivateDataSourcePool(BasicDataSource dataSourcePool) throws Exception {
            dataSourcePool.close();
        }
    }
}

