/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.metrics;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.qi4j.api.common.Optional;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.injection.scope.Invocation;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.metrics.MetricsProvider;
import org.qi4j.api.metrics.MetricsTimer;
import org.qi4j.api.metrics.MetricsTimerFactory;
import org.qi4j.library.metrics.TimingCapture;

public class TimingCaptureAllConcern
extends ConcernOf<InvocationHandler>
implements InvocationHandler {
    private MetricsTimer timer;

    public TimingCaptureAllConcern(@Service @Optional MetricsProvider metrics, @Invocation Method method) {
        if (metrics != null) {
            MetricsTimerFactory factory = (MetricsTimerFactory)metrics.createFactory(MetricsTimerFactory.class);
            boolean annotated = method.getAnnotation(TimingCapture.class) != null;
            String captureNme = this.getMethodName(method) + "() [" + (annotated ? "@" : "") + "TimingCapture" + "]";
            Class<?> declaringClass = method.getDeclaringClass();
            this.timer = factory.createTimer(declaringClass, captureNme, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        }
    }

    private String getMethodName(Method method) {
        return method.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MetricsTimer.Context timing = null;
        if (this.timer != null) {
            timing = this.timer.start();
        }
        try {
            Object object = ((InvocationHandler)this.next).invoke(proxy, method, args);
            return object;
        }
        finally {
            if (timing != null) {
                timing.stop();
            }
        }
    }
}

