/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.jmx;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.DescriptorSupport;
import org.qi4j.api.Qi4j;
import org.qi4j.api.activation.Activation;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.EnumType;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.functional.Iterables;
import org.qi4j.library.jmx.Qi4jMBeans;
import org.qi4j.spi.Qi4jSPI;

@Mixins(value={Mixin.class})
@Activators(value={Activator.class})
public interface ConfigurationManagerService
extends ServiceComposite {
    public void exportConfigurableServices() throws Exception;

    public void unexportConfigurableServices() throws Exception;

    public static abstract class Mixin
    implements ConfigurationManagerService {
        @Structure
        UnitOfWorkFactory uowf;
        @Service
        MBeanServer server;
        @Structure
        Application application;
        @Structure
        Qi4jSPI spi;
        @Service
        Iterable<ServiceReference<?>> configurableServices;
        private List<ObjectName> configurationNames = new ArrayList<ObjectName>();

        @Override
        public void exportConfigurableServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
            for (ServiceReference<?> configurableService : this.configurableServices) {
                Object service = configurableService.get();
                if (!(service instanceof Composite)) continue;
                CompositeInstance compositeInstance = (CompositeInstance)Qi4j.FUNCTION_COMPOSITE_INSTANCE_OF.map((Object)((Composite)service));
                try {
                    Configuration config = (Configuration)compositeInstance.newProxy(Configuration.class);
                }
                catch (Exception e) {
                    continue;
                }
                String serviceClass = ((Class)Iterables.first((Iterable)compositeInstance.types())).getName();
                String name = configurableService.identity();
                ServiceDescriptor serviceDescriptor = this.spi.serviceDescriptorFor(configurableService);
                Module module = this.spi.moduleOf(configurableService);
                Class configurationClass = serviceDescriptor.configurationType();
                if (configurationClass == null) continue;
                EntityDescriptor descriptor = module.entityDescriptor(configurationClass.getName());
                ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
                HashMap<String, AccessibleObject> properties = new HashMap<String, AccessibleObject>();
                for (PropertyDescriptor persistentProperty : descriptor.state().properties()) {
                    if (persistentProperty.isImmutable()) continue;
                    String propertyName = persistentProperty.qualifiedName().name();
                    String type = persistentProperty.valueType().mainType().getName();
                    DescriptorSupport attrDescriptor = new DescriptorSupport();
                    attrDescriptor.setField("name", propertyName);
                    attrDescriptor.setField("descriptorType", "attribute");
                    if (persistentProperty.valueType() instanceof EnumType) {
                        type = String.class.getName();
                        try {
                            LinkedHashSet<String> legalValues = new LinkedHashSet<String>();
                            Class<?> enumType = this.getClass().getClassLoader().loadClass(persistentProperty.valueType().mainType().getName());
                            for (Field field : enumType.getFields()) {
                                legalValues.add(field.getName());
                            }
                            attrDescriptor.setField("legalValues", legalValues);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    attributes.add(new MBeanAttributeInfo(propertyName, type, propertyName, true, true, type.equals("java.lang.Boolean"), attrDescriptor));
                    properties.put(propertyName, persistentProperty.accessor());
                }
                ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
                operations.add(new MBeanOperationInfo("restart", "Restart service", new MBeanParameterInfo[0], "java.lang.String", 2));
                MBeanInfo mbeanInfo = new MBeanInfo(serviceClass, name, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), null, operations.toArray(new MBeanOperationInfo[operations.size()]), null);
                ConfigurableService mbean = new ConfigurableService(configurableService, mbeanInfo, name, properties);
                ObjectName serviceName = Qi4jMBeans.findServiceName(this.server, this.application.name(), name);
                ObjectName configurableServiceName = serviceName != null ? new ObjectName(serviceName.toString() + ",name=Configuration") : new ObjectName("Configuration:name=" + name);
                this.server.registerMBean(mbean, configurableServiceName);
                this.configurationNames.add(configurableServiceName);
            }
        }

        @Override
        public void unexportConfigurableServices() throws Exception {
            for (ObjectName configurableServiceName : this.configurationNames) {
                this.server.unregisterMBean(configurableServiceName);
            }
        }

        class ConfigurableService
        extends EditableConfiguration {
            private ServiceReference<?> serviceRef;

            ConfigurableService(ServiceReference<?> serviceReference, MBeanInfo info, String identity, Map<String, AccessibleObject> propertyNames) {
                super(info, identity, propertyNames);
                this.serviceRef = serviceReference;
            }

            @Override
            public Object invoke(String s, Object[] objects, String[] strings) throws MBeanException, ReflectionException {
                if (s.equals("restart")) {
                    try {
                        if (this.serviceRef.isActive()) {
                            CompositeInstance compositeInstance = (CompositeInstance)Qi4j.FUNCTION_COMPOSITE_INSTANCE_OF.map((Object)((Composite)this.serviceRef.get()));
                            ((Configuration)compositeInstance.newProxy(Configuration.class)).refresh();
                            ((Activation)this.serviceRef).passivate();
                            ((Activation)this.serviceRef).activate();
                        }
                        return "Service restarted";
                    }
                    catch (Exception e) {
                        return "Could not restart service:" + e.getMessage();
                    }
                }
                return "Unknown operation";
            }
        }

        abstract class EditableConfiguration
        implements DynamicMBean {
            MBeanInfo info;
            String identity;
            Map<String, AccessibleObject> propertyNames;

            EditableConfiguration(MBeanInfo info, String identity, Map<String, AccessibleObject> propertyNames) {
                this.info = info;
                this.identity = identity;
                this.propertyNames = propertyNames;
            }

            @Override
            public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
                UnitOfWork uow = Mixin.this.uowf.newUnitOfWork();
                try {
                    EntityComposite configuration = (EntityComposite)uow.get(EntityComposite.class, this.identity);
                    AssociationStateHolder state = Mixin.this.spi.stateOf(configuration);
                    AccessibleObject accessor = this.propertyNames.get(name);
                    Property property = state.propertyFor(accessor);
                    Object object = property.get();
                    if (object instanceof Enum) {
                        object = object.toString();
                    }
                    Object object2 = object;
                    return object2;
                }
                catch (Exception ex) {
                    throw new ReflectionException(ex, "Could not get attribute " + name);
                }
                finally {
                    uow.discard();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
                UnitOfWork uow = Mixin.this.uowf.newUnitOfWork();
                try {
                    EntityComposite configuration = (EntityComposite)uow.get(EntityComposite.class, this.identity);
                    AssociationStateHolder state = Mixin.this.spi.stateOf(configuration);
                    AccessibleObject accessor = this.propertyNames.get(attribute.getName());
                    Property property = state.propertyFor(accessor);
                    PropertyDescriptor propertyDescriptor = Mixin.this.spi.propertyDescriptorFor(property);
                    if (EnumType.isEnum((Type)propertyDescriptor.type())) {
                        property.set(Enum.valueOf((Class)propertyDescriptor.type(), attribute.getValue().toString()));
                    } else {
                        property.set(attribute.getValue());
                    }
                    try {
                        uow.complete();
                    }
                    catch (UnitOfWorkCompletionException e) {
                        throw new ReflectionException((Exception)((Object)e));
                    }
                }
                finally {
                    uow.discard();
                }
            }

            @Override
            public AttributeList getAttributes(String[] names) {
                AttributeList list = new AttributeList();
                for (String name : names) {
                    try {
                        Object value = this.getAttribute(name);
                        list.add(new Attribute(name, value));
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (MBeanException e) {
                        e.printStackTrace();
                    }
                    catch (ReflectionException e) {
                        e.printStackTrace();
                    }
                }
                return list;
            }

            @Override
            public AttributeList setAttributes(AttributeList attributeList) {
                AttributeList list = new AttributeList();
                for (int i = 0; i < list.size(); ++i) {
                    Attribute attribute = (Attribute)list.get(i);
                    try {
                        this.setAttribute(attribute);
                        list.add(attribute);
                        continue;
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvalidAttributeValueException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (MBeanException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (ReflectionException e) {
                        e.printStackTrace();
                    }
                }
                return list;
            }

            @Override
            public MBeanInfo getMBeanInfo() {
                return this.info;
            }
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<ConfigurationManagerService>> {
        public void afterActivation(ServiceReference<ConfigurationManagerService> activated) throws Exception {
            ((ConfigurationManagerService)activated.get()).exportConfigurableServices();
        }

        public void beforePassivation(ServiceReference<ConfigurationManagerService> passivating) throws Exception {
            ((ConfigurationManagerService)passivating.get()).unexportConfigurableServices();
        }
    }
}

