/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.cache.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Element;
import org.qi4j.spi.cache.Cache;

public class EhCacheImpl<T>
implements Cache<T> {
    private int refCount;
    private final net.sf.ehcache.Cache backingCache;
    private final Class<T> valueType;
    private final String id;

    public EhCacheImpl(String cacheId, net.sf.ehcache.Cache cache, Class<T> valueType) {
        this.id = cacheId;
        this.backingCache = cache;
        this.valueType = valueType;
    }

    public T get(String key) {
        Element element = this.backingCache.get((Serializable)((Object)key));
        if (element == null) {
            return null;
        }
        return this.valueType.cast(element.getObjectValue());
    }

    public T remove(String key) {
        T old = this.valueType.cast(this.backingCache.get((Serializable)((Object)key)).getObjectValue());
        this.backingCache.remove((Serializable)((Object)key));
        return old;
    }

    public void put(String key, T value) {
        Element element = new Element((Object)key, value);
        this.backingCache.put(element);
    }

    public boolean exists(String key) {
        return this.backingCache.isKeyInCache((Object)key);
    }

    synchronized void decRefCount() {
        --this.refCount;
    }

    synchronized void incRefCount() {
        ++this.refCount;
    }

    synchronized boolean isNotUsed() {
        return this.refCount == 0;
    }

    public String cacheId() {
        return this.id;
    }
}

