/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.cache.ehcache;

import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.PersistenceConfiguration;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.cache.ehcache.EhCacheConfiguration;
import org.qi4j.cache.ehcache.EhCacheImpl;
import org.qi4j.cache.ehcache.EhCachePoolService;
import org.qi4j.spi.cache.Cache;

public abstract class EhCachePoolMixin
implements EhCachePoolService {
    private final ConcurrentHashMap<String, EhCacheImpl<?>> caches = new ConcurrentHashMap();
    @This
    @Optional
    private org.qi4j.api.configuration.Configuration<EhCacheConfiguration> config;
    private CacheManager cacheManager;

    public <T> Cache<T> fetchCache(String cacheId, Class<T> valueType) {
        NullArgumentException.validateNotEmpty((String)"cacheId", (String)cacheId);
        EhCacheImpl<Object> cache = this.caches.get(cacheId);
        if (cache == null) {
            cache = this.createNewCache(cacheId, valueType);
            this.caches.put(cacheId, cache);
        }
        cache.incRefCount();
        return cache;
    }

    private <T> EhCacheImpl<T> createNewCache(String cacheId, Class<T> valueType) {
        CacheConfiguration cc = this.createCacheConfiguration(cacheId);
        net.sf.ehcache.Cache cache = new net.sf.ehcache.Cache(cc);
        this.cacheManager.addCache(cache);
        return new EhCacheImpl<T>(cacheId, cache, valueType);
    }

    public void returnCache(Cache<?> cache) {
        EhCacheImpl eh = (EhCacheImpl)cache;
        eh.decRefCount();
        if (eh.isNotUsed()) {
            this.caches.remove(eh.cacheId());
            this.cacheManager.removeCache(eh.cacheId());
        }
    }

    public void activateService() throws Exception {
        Configuration configuration = new Configuration();
        this.configureEhCache(configuration);
        CacheConfiguration cc = this.createCacheConfiguration("qi4j.ehcache.config.default");
        configuration.setDefaultCacheConfiguration(cc);
        this.cacheManager = CacheManager.newInstance((Configuration)configuration);
    }

    public void passivateService() throws Exception {
        this.cacheManager.shutdown();
    }

    private void configureEhCache(Configuration configuration) {
        String name;
        EhCacheConfiguration conf = (EhCacheConfiguration)this.config.get();
        Boolean updateCheck = (Boolean)conf.updateCheck().get();
        configuration.setUpdateCheck(updateCheck.booleanValue());
        configuration.setDynamicConfig(true);
        String monitoring = ((String)conf.monitoring().get()).trim();
        if (monitoring.length() > 0) {
            configuration.setMonitoring(monitoring);
        }
        if ((name = (String)conf.cacheManagerName().get()) == null) {
            name = "Zest Cache Extension";
        }
        configuration.setName(name);
        String diskStorePath = (String)conf.diskStorePath().get();
        if (diskStorePath.length() > 0) {
            configuration.getDiskStoreConfiguration().path(diskStorePath);
        }
    }

    private CacheConfiguration createCacheConfiguration(String cacheId) {
        Boolean clearOnFlush;
        Integer diskAccessStripes;
        Long diskExpiryThreadIntervalSeconds;
        Boolean loggingEnabled;
        Integer maxElementsOnDisk;
        String memoryStoreEvictionPolicy;
        String name;
        Long timeToIdleSeconds;
        Long timeToLiveSeconds;
        EhCacheConfiguration conf = (EhCacheConfiguration)this.config.get();
        Integer maxElementsInMemory = (Integer)conf.maxElementsInMemory().get();
        if (maxElementsInMemory <= 0) {
            maxElementsInMemory = 10000;
        }
        CacheConfiguration cacheConfig = new CacheConfiguration(cacheId, maxElementsInMemory.intValue());
        String transactionalMode = (String)conf.transactionalMode().get();
        if (transactionalMode.length() > 0) {
            cacheConfig.transactionalMode(transactionalMode);
        }
        if ((timeToLiveSeconds = (Long)conf.timeToLiveSeconds().get()) > 0L) {
            cacheConfig.timeToLiveSeconds(timeToLiveSeconds.longValue());
        }
        if ((timeToIdleSeconds = (Long)conf.timeToIdleSeconds().get()) > 0L) {
            cacheConfig.timeToIdleSeconds(timeToIdleSeconds.longValue());
        }
        if ((name = (String)conf.name().get()).length() > 0) {
            cacheConfig.name(name);
        }
        if ((memoryStoreEvictionPolicy = (String)conf.memoryStoreEvictionPolicy().get()).length() > 0) {
            cacheConfig.memoryStoreEvictionPolicy(memoryStoreEvictionPolicy);
        }
        if ((maxElementsOnDisk = (Integer)conf.maxElementsOnDisk().get()) > 0) {
            cacheConfig.maxElementsOnDisk(maxElementsOnDisk.intValue());
        }
        if ((loggingEnabled = (Boolean)conf.loggingEnabled().get()) != null) {
            cacheConfig.logging(loggingEnabled.booleanValue());
        }
        Boolean eternal = (Boolean)conf.eternal().get();
        cacheConfig.eternal(eternal.booleanValue());
        Integer diskSpoolBufferSizeMB = (Integer)conf.diskSpoolBufferSizeMB().get();
        if (diskSpoolBufferSizeMB > 0) {
            cacheConfig.diskSpoolBufferSizeMB(diskSpoolBufferSizeMB.intValue());
        }
        if ((diskExpiryThreadIntervalSeconds = (Long)conf.diskExpiryThreadIntervalSeconds().get()) > 0L) {
            cacheConfig.diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds.longValue());
        }
        if ((diskAccessStripes = (Integer)conf.diskAccessStripes().get()) > 0) {
            cacheConfig.diskAccessStripes(diskAccessStripes.intValue());
        }
        if ((clearOnFlush = (Boolean)conf.clearOnFlush().get()) != null) {
            cacheConfig.clearOnFlush(clearOnFlush.booleanValue());
        }
        PersistenceConfiguration persistenceConfig = new PersistenceConfiguration();
        PersistenceConfiguration.Strategy strategy = (PersistenceConfiguration.Strategy)conf.persistenceStrategy().get();
        if (strategy == null) {
            persistenceConfig.strategy(PersistenceConfiguration.Strategy.NONE);
        } else {
            persistenceConfig.strategy(strategy);
        }
        cacheConfig.persistence(persistenceConfig);
        return cacheConfig;
    }
}

