/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.shiro.domain.passwords;

import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Authorizer;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.query.QueryBuilder;
import org.qi4j.api.query.QueryExpressions;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.functional.Specification;
import org.qi4j.library.shiro.Shiro;
import org.qi4j.library.shiro.domain.passwords.PasswordRealmConfiguration;
import org.qi4j.library.shiro.domain.passwords.PasswordSecurable;
import org.qi4j.library.shiro.domain.permissions.RoleAssignee;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordRealmMixin
extends AuthorizingRealm
implements Realm,
Authorizer,
PasswordService,
ServiceActivation {
    private static final Logger LOG = LoggerFactory.getLogger((String)Shiro.LOGGER_NAME);
    @Structure
    private Module module;
    @This
    private Configuration<PasswordRealmConfiguration> configuration;
    private final DefaultPasswordService passwordService = new DefaultPasswordService();

    public PasswordRealmMixin() {
        PasswordMatcher matcher = new PasswordMatcher();
        matcher.setPasswordService((PasswordService)this.passwordService);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    public void activateService() throws Exception {
        this.configuration.refresh();
        PasswordRealmConfiguration config = (PasswordRealmConfiguration)this.configuration.get();
        String algorithm = (String)config.hashAlgorithmName().get();
        Integer iterations = (Integer)config.hashIterationsCount().get();
        if (algorithm != null || iterations != null) {
            DefaultHashService hashService = (DefaultHashService)this.passwordService.getHashService();
            if (algorithm != null) {
                hashService.setHashAlgorithmName(algorithm);
            }
            if (iterations != null) {
                hashService.setHashIterations(iterations.intValue());
            }
        }
    }

    public void passivateService() throws Exception {
    }

    public String encryptPassword(Object plaintextPassword) throws IllegalArgumentException {
        return this.passwordService.encryptPassword(plaintextPassword);
    }

    public boolean passwordsMatch(Object submittedPlaintext, String encrypted) {
        return this.passwordService.passwordsMatch(submittedPlaintext, encrypted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UnitOfWork uow = this.module.newUnitOfWork();
        try {
            String username = ((UsernamePasswordToken)token).getUsername();
            PasswordSecurable account = this.findPasswordSecurable(uow, username);
            if (account == null) {
                LOG.debug("Unknown subject identifier: {}" + username);
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            LOG.debug("Found account for {}: {}", (Object)username, (Object)account);
            SimpleAuthenticationInfo simpleAuthenticationInfo = new SimpleAuthenticationInfo(account.subjectIdentifier().get(), account.password().get(), this.getName());
            return simpleAuthenticationInfo;
        }
        finally {
            uow.discard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        UnitOfWork uow = this.module.newUnitOfWork();
        try {
            String username = this.getAvailablePrincipal(principals).toString();
            RoleAssignee roleAssignee = this.findRoleAssignee(uow, username);
            if (roleAssignee == null) {
                LOG.debug("No authorization info for {}", (Object)username);
                AuthorizationInfo authorizationInfo = null;
                return authorizationInfo;
            }
            LOG.debug("Found role assignee for {}: {}", (Object)username, (Object)roleAssignee);
            Set<String> roleNames = roleAssignee.roleNames();
            Set<String> permissionStrings = roleAssignee.permissionStrings();
            LOG.debug("Found role assignee has the following roles: {}", roleNames);
            LOG.debug("Found role assignee has the following permissions: {}", permissionStrings);
            SimpleAuthorizationInfo atzInfo = new SimpleAuthorizationInfo(roleNames);
            atzInfo.setStringPermissions(permissionStrings);
            SimpleAuthorizationInfo simpleAuthorizationInfo = atzInfo;
            return simpleAuthorizationInfo;
        }
        finally {
            uow.discard();
        }
    }

    private PasswordSecurable findPasswordSecurable(UnitOfWork uow, String username) {
        QueryBuilder builder = this.module.newQueryBuilder(PasswordSecurable.class);
        builder = builder.where((Specification)QueryExpressions.eq(((PasswordSecurable)QueryExpressions.templateFor(PasswordSecurable.class)).subjectIdentifier(), (Object)username));
        return (PasswordSecurable)uow.newQuery(builder).find();
    }

    private RoleAssignee findRoleAssignee(UnitOfWork uow, String username) {
        QueryBuilder builder = this.module.newQueryBuilder(RoleAssignee.class);
        builder = builder.where((Specification)QueryExpressions.eq(((RoleAssignee)QueryExpressions.templateFor(RoleAssignee.class)).subjectIdentifier(), (Object)username));
        return (RoleAssignee)uow.newQuery(builder).find();
    }
}

