/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.shiro.domain.permissions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.entity.Aggregated;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.library.shiro.domain.common.IdentifiableSubject;
import org.qi4j.library.shiro.domain.permissions.Role;
import org.qi4j.library.shiro.domain.permissions.RoleAssignment;

@Mixins(value={Mixin.class})
public interface RoleAssignee
extends IdentifiableSubject,
EntityComposite {
    @Aggregated
    @UseDefaults
    public ManyAssociation<RoleAssignment> roleAssignments();

    public Set<String> roleNames();

    public Set<String> permissionStrings();

    public static abstract class Mixin
    implements RoleAssignee {
        @This
        private RoleAssignee roleAssignee;

        @Override
        public Set<String> roleNames() {
            HashSet<Object> roleNames = new HashSet<Object>();
            for (RoleAssignment assignment : this.roleAssignee.roleAssignments()) {
                roleNames.add(((Role)assignment.role().get()).name().get());
            }
            return Collections.unmodifiableSet(roleNames);
        }

        @Override
        public Set<String> permissionStrings() {
            HashSet permissionStrings = new HashSet();
            for (RoleAssignment assignment : this.roleAssignee.roleAssignments()) {
                permissionStrings.addAll((Collection)((Role)assignment.role().get()).permissions().get());
            }
            return Collections.unmodifiableSet(permissionStrings);
        }
    }
}

