/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.scheduler;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.library.scheduler.Scheduler;
import org.qi4j.library.scheduler.SchedulerMixin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={SchedulerMixin.class, ThreadFactory.class, RejectionHandler.class})
public interface SchedulerService
extends Scheduler,
ServiceActivation,
Identity {

    public static class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        protected ThreadFactory(@This SchedulerService me) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = (String)me.identity().get() + "-P" + POOL_NUMBER.getAndIncrement() + "W";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    public static class RejectionHandler
    implements RejectedExecutionHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerService.class);

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            LOGGER.error("Runnable [" + r + "] was rejected by executor [" + executor + "]");
        }
    }
}

