/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.scheduler.schedule;

import org.joda.time.DateTime;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.library.scheduler.SchedulerService;
import org.qi4j.library.scheduler.Task;
import org.qi4j.library.scheduler.schedule.Schedule;
import org.qi4j.library.scheduler.schedule.cron.CronSchedule;
import org.qi4j.library.scheduler.schedule.once.OnceSchedule;
import org.qi4j.spi.uuid.UuidIdentityGeneratorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface ScheduleFactory {
    public Schedule newCronSchedule(Task var1, String var2, DateTime var3, boolean var4);

    public Schedule newOnceSchedule(Task var1, DateTime var2, boolean var3);

    public static class Mixin
    implements ScheduleFactory {
        private static final Logger logger = LoggerFactory.getLogger(ScheduleFactory.class);
        @Structure
        private Module module;
        @Service
        private SchedulerService scheduler;
        @Service
        private UuidIdentityGeneratorService uuid;

        @Override
        public CronSchedule newCronSchedule(Task task, String cronExpression, DateTime start, boolean durable) {
            if (durable) {
                return this.newPersistentCronSchedule(task, cronExpression, start);
            }
            return this.newTransientCronSchedule(task, cronExpression, start);
        }

        @Override
        public Schedule newOnceSchedule(Task task, DateTime runAt, boolean durable) {
            if (durable) {
                return this.newPersistentOnceSchedule(task, runAt);
            }
            return this.newTransientOnceSchedule(task, runAt);
        }

        private CronSchedule newTransientCronSchedule(Task task, String cronExpression, DateTime start) {
            ValueBuilder builder = this.module.newValueBuilder(CronSchedule.class);
            CronSchedule prototype = (CronSchedule)builder.prototype();
            prototype.task().set((Object)task);
            prototype.start().set((Object)start);
            prototype.identity().set((Object)this.uuid.generate(CronSchedule.class));
            prototype.cronExpression().set((Object)cronExpression);
            CronSchedule schedule = (CronSchedule)builder.newInstance();
            logger.info("Schedule {} created: {}", (Object)schedule.presentationString(), schedule.identity().get());
            return schedule;
        }

        private CronSchedule newPersistentCronSchedule(Task task, String cronExpression, DateTime start) {
            UnitOfWork uow = this.module.currentUnitOfWork();
            EntityBuilder builder = uow.newEntityBuilder(CronSchedule.class);
            CronSchedule builderInstance = (CronSchedule)builder.instance();
            builderInstance.task().set((Object)task);
            builderInstance.start().set((Object)start);
            builderInstance.identity().set((Object)this.uuid.generate(CronSchedule.class));
            builderInstance.cronExpression().set((Object)cronExpression);
            CronSchedule schedule = (CronSchedule)builder.newInstance();
            logger.info("Schedule {} created: {}", (Object)schedule.presentationString(), schedule.identity().get());
            return schedule;
        }

        private Schedule newTransientOnceSchedule(Task task, DateTime runAt) {
            ValueBuilder builder = this.module.newValueBuilder(OnceSchedule.class);
            OnceSchedule builderInstance = (OnceSchedule)builder.prototype();
            builderInstance.task().set((Object)task);
            builderInstance.start().set((Object)runAt);
            builderInstance.identity().set((Object)this.uuid.generate(CronSchedule.class));
            OnceSchedule schedule = (OnceSchedule)builder.newInstance();
            logger.info("Schedule {} created: {}", (Object)schedule.presentationString(), schedule.identity().get());
            return schedule;
        }

        private Schedule newPersistentOnceSchedule(Task task, DateTime runAt) {
            UnitOfWork uow = this.module.currentUnitOfWork();
            EntityBuilder builder = uow.newEntityBuilder(OnceSchedule.class);
            OnceSchedule builderInstance = (OnceSchedule)builder.instance();
            builderInstance.task().set((Object)task);
            builderInstance.start().set((Object)runAt);
            builderInstance.identity().set((Object)this.uuid.generate(CronSchedule.class));
            OnceSchedule schedule = (OnceSchedule)builder.newInstance();
            logger.info("Schedule {} created: {}", (Object)schedule.presentationString(), schedule.identity().get());
            return schedule;
        }
    }
}

