/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.scheduler.schedule.cron;

import org.joda.time.DateTime;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Immutable;
import org.qi4j.api.property.Property;
import org.qi4j.library.scheduler.schedule.Schedule;
import org.qi4j.library.scheduler.schedule.cron.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={CronScheduleMixin.class})
public interface CronSchedule
extends Schedule {
    @CronExpression
    @Immutable
    public Property<String> cronExpression();

    public static abstract class CronScheduleMixin
    implements CronSchedule {
        private static final Logger LOGGER = LoggerFactory.getLogger(Schedule.class);
        private boolean running;

        @Override
        public void taskStarting() {
            this.running = true;
        }

        @Override
        public void taskCompletedSuccessfully() {
            this.running = false;
        }

        @Override
        public void taskCompletedWithException(RuntimeException ex) {
            this.running = false;
        }

        @Override
        public String presentationString() {
            return (String)this.cronExpression().get();
        }

        @Override
        public boolean isTaskRunning() {
            return false;
        }

        @Override
        public long nextRun(long from) {
            long actualFrom = from;
            long firstRun = ((DateTime)this.start().get()).getMillis();
            if (firstRun > from) {
                actualFrom = firstRun;
            }
            Long nextRun = new org.codeartisans.sked.cron.CronSchedule((String)this.cronExpression().get()).firstRunAfter(Long.valueOf(actualFrom));
            LOGGER.info("CronSchedule::nextRun({}) is {}", (Object)from, (Object)firstRun);
            return nextRun;
        }
    }
}

