/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.scheduler.schedule.once;

import org.joda.time.DateTime;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.library.scheduler.schedule.Schedule;

@Mixins(value={OnceScheduleMixin.class})
public interface OnceSchedule
extends Schedule {

    public static abstract class OnceScheduleMixin
    implements OnceSchedule {
        private boolean running;

        @Override
        public void taskStarting() {
            this.running = true;
        }

        @Override
        public void taskCompletedSuccessfully() {
            this.running = false;
        }

        @Override
        public void taskCompletedWithException(RuntimeException ex) {
            this.running = false;
        }

        @Override
        public boolean isTaskRunning() {
            return this.running;
        }

        @Override
        public long nextRun(long from) {
            long runAt = ((DateTime)this.start().get()).getMillis();
            if (runAt >= from) {
                return runAt;
            }
            return -1L;
        }

        @Override
        public String presentationString() {
            return ((DateTime)this.start().get()).toString();
        }
    }
}

