/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.scheduler.timeline;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.library.scheduler.Task;
import org.qi4j.library.scheduler.schedule.Schedule;
import org.qi4j.library.scheduler.timeline.TimelineRecord;
import org.qi4j.library.scheduler.timeline.TimelineRecordStep;
import org.qi4j.library.scheduler.timeline.TimelineScheduleState;

public abstract class TimelineForScheduleConcern
extends ConcernOf<Schedule>
implements Schedule {
    @This
    private TimelineScheduleState state;
    @Structure
    private Module module;

    @Override
    public void taskStarting() {
        this.addRecord(TimelineRecordStep.STARTED, "");
        ((Schedule)this.next).taskStarting();
    }

    @Override
    public void taskCompletedSuccessfully() {
        this.addRecord(TimelineRecordStep.SUCCESS, "");
        ((Schedule)this.next).taskCompletedSuccessfully();
    }

    @Override
    public void taskCompletedWithException(RuntimeException ex) {
        TimelineRecordStep step = TimelineRecordStep.FAILURE;
        String details = "Exception occurred:" + this.getStackTrace(ex);
        this.addRecord(step, details);
        ((Schedule)this.next).taskCompletedWithException(ex);
    }

    private void addRecord(TimelineRecordStep step, String details) {
        ValueBuilder builder = this.module.newValueBuilder(TimelineRecord.class);
        TimelineRecord prototype = (TimelineRecord)builder.prototype();
        prototype.step().set((Object)step);
        prototype.taskName().set(((Task)this.task().get()).name().get());
        List tags = (List)((Task)this.task().get()).tags().get();
        prototype.taskTags().set((Object)tags);
        prototype.timestamp().set((Object)System.currentTimeMillis());
        prototype.scheduleIdentity().set(this.identity().get());
        prototype.details().set((Object)details);
        TimelineRecord record = (TimelineRecord)builder.newInstance();
        List timelineRecords = (List)this.state.history().get();
        timelineRecords.add(record);
        this.state.history().set((Object)timelineRecords);
    }

    private String getStackTrace(RuntimeException ex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        BufferedOutputStream out = new BufferedOutputStream(baos);
        PrintStream print = new PrintStream(out);
        ex.printStackTrace(print);
        print.flush();
        return baos.toString();
    }
}

