/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.common.link;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.qi4j.api.common.Optional;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.library.rest.common.link.Link;
import org.qi4j.library.rest.common.link.Links;

public class LinksBuilder<T extends LinksBuilder> {
    protected ValueBuilder<? extends Links> linksBuilder;
    protected ValueBuilder<Link> linkBuilder;
    protected ValueBuilderFactory vbf;
    private String path;
    private String rel;
    private String classes;
    private String command;

    public LinksBuilder(ValueBuilderFactory vbf) {
        this.vbf = vbf;
        this.linksBuilder = vbf.newValueBuilder(Links.class);
        this.linkBuilder = vbf.newValueBuilder(Link.class);
    }

    public T path(@Optional String subPath) {
        this.path = subPath;
        return (T)this;
    }

    public T rel(String rel) {
        this.rel = rel;
        return (T)this;
    }

    public T classes(String classes) {
        this.classes = classes;
        return (T)this;
    }

    public T command(String commandName) {
        this.command = commandName;
        this.rel = commandName;
        return (T)this;
    }

    public T addLink(Link link) {
        ((List)((Links)this.linksBuilder.prototype()).links().get()).add(link);
        this.linkBuilder = this.vbf.newValueBuilderWithPrototype((Object)link);
        return (T)this;
    }

    public T addLink(String description, String id) {
        try {
            ((Link)this.linkBuilder.prototype()).text().set((Object)description);
            ((Link)this.linkBuilder.prototype()).id().set((Object)id);
            if (this.command != null) {
                ((Link)this.linkBuilder.prototype()).href().set((Object)(this.command + "?entity=" + id));
            } else {
                ((Link)this.linkBuilder.prototype()).href().set((Object)((this.path == null ? "" : this.path + "/") + URLEncoder.encode(id, "UTF-8") + "/"));
            }
            ((Link)this.linkBuilder.prototype()).rel().set((Object)this.rel);
            ((Link)this.linkBuilder.prototype()).classes().set((Object)this.classes);
            this.addLink((Link)this.linkBuilder.newInstance());
            return (T)this;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return (T)this;
        }
    }

    public T addLink(String description, String id, String rel, String href, String classes) {
        ((Link)this.linkBuilder.prototype()).text().set((Object)description);
        ((Link)this.linkBuilder.prototype()).id().set((Object)id);
        ((Link)this.linkBuilder.prototype()).rel().set((Object)rel);
        ((Link)this.linkBuilder.prototype()).href().set((Object)href);
        ((Link)this.linkBuilder.prototype()).classes().set((Object)classes);
        this.addLink((Link)this.linkBuilder.newInstance());
        return (T)this;
    }

    public Links newLinks() {
        return (Links)this.linksBuilder.newInstance();
    }
}

