/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.common.table;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.library.rest.common.table.Cell;
import org.qi4j.library.rest.common.table.Column;
import org.qi4j.library.rest.common.table.Row;
import org.qi4j.library.rest.common.table.Table;

@Mixins(value={Mixin.class})
public interface TableQuery
extends ValueComposite {
    public Property<String> tq();

    public String select();

    public String where();

    public String groupBy();

    public String pivot();

    public String orderBy();

    public String limit();

    public String offset();

    public String label();

    public String options();

    public Table applyTo(Table var1);

    public static abstract class Mixin
    implements TableQuery {
        private static Collection<String> keywords = Arrays.asList("select", "where", "group by", "pivot", "order by", "limit", "offset", "label", "options");
        private Map<String, String> parts;

        @Override
        public String select() {
            return this.getParts().get("select");
        }

        @Override
        public String where() {
            return this.getParts().get("where");
        }

        @Override
        public String groupBy() {
            return this.getParts().get("group by");
        }

        @Override
        public String pivot() {
            return this.getParts().get("pivot");
        }

        @Override
        public String orderBy() {
            return this.getParts().get("order by");
        }

        @Override
        public String limit() {
            return this.getParts().get("limit");
        }

        @Override
        public String offset() {
            return this.getParts().get("offset");
        }

        @Override
        public String label() {
            return this.getParts().get("label");
        }

        @Override
        public String options() {
            return this.getParts().get("options");
        }

        private Map<String, String> getParts() {
            if (this.parts == null) {
                this.parts = new HashMap<String, String>();
                String value = (String)this.tq().get();
                List<String> values = Arrays.asList(value.split(" "));
                Collections.reverse(values);
                String currentPhrase = "";
                for (String str : values) {
                    currentPhrase = str + currentPhrase;
                    boolean found = false;
                    for (String keyword : keywords) {
                        if (!currentPhrase.startsWith(keyword + " ")) continue;
                        found = true;
                        this.parts.put(keyword, currentPhrase.substring(keyword.length() + 1));
                        currentPhrase = "";
                        break;
                    }
                    if (found) continue;
                    currentPhrase = " " + currentPhrase;
                }
            }
            return this.parts;
        }

        @Override
        public Table applyTo(Table table) {
            ValueBuilder tableBuilder = ((CompositeInstance)Qi4j.FUNCTION_COMPOSITE_INSTANCE_OF.map((Object)table)).module().newValueBuilderWithPrototype((Object)table);
            if (this.orderBy() != null) {
                int sortIndex = -1;
                List columns = (List)table.cols().get();
                for (int i = 0; i < columns.size(); ++i) {
                    Column column = (Column)columns.get(i);
                    if (!column.id().equals((Object)this.orderBy())) continue;
                    sortIndex = i;
                    break;
                }
                if (sortIndex != -1) {
                    final int idx = sortIndex;
                    Comparator<Row> comparator = new Comparator<Row>(){

                        @Override
                        public int compare(Row o1, Row o2) {
                            Object o = ((Cell)((List)o1.c().get()).get(idx)).v().get();
                            if (o != null && o instanceof Comparable) {
                                Comparable c1 = (Comparable)o;
                                Comparable c2 = (Comparable)((Cell)((List)o2.c().get()).get(idx)).v().get();
                                return c1.compareTo(c2);
                            }
                            String f1 = (String)((Cell)((List)o1.c().get()).get(idx)).f().get();
                            String f2 = (String)((Cell)((List)o2.c().get()).get(idx)).f().get();
                            return f1.compareTo(f2);
                        }
                    };
                    Collections.sort((List)((Table)tableBuilder.prototype()).rows().get(), comparator);
                }
            }
            int start = 0;
            int end = ((List)((Table)tableBuilder.prototype()).rows().get()).size();
            if (this.offset() != null) {
                start = Integer.parseInt(this.offset());
            }
            if (this.limit() != null) {
                end = Math.min(end, start + Integer.parseInt(this.limit()));
            }
            if (start != 0 || end != ((List)((Table)tableBuilder.prototype()).rows().get()).size()) {
                ((Table)tableBuilder.prototype()).rows().set(((List)((Table)tableBuilder.prototype()).rows().get()).subList(start, end));
            }
            return (Table)tableBuilder.newInstance();
        }
    }
}

