/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.component.Container;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.functional.Iterables;
import org.qi4j.library.http.HttpService;
import org.qi4j.library.http.Interface;
import org.qi4j.library.http.InterfaceImpl;
import org.qi4j.library.http.JettyActivation;
import org.qi4j.library.http.JettyConfiguration;
import org.qi4j.library.http.JettyConfigurationHelper;

public abstract class AbstractJettyMixin
implements HttpService,
JettyActivation {
    private final String identity;
    private final Iterable<ServiceReference<ServletContextListener>> contextListeners;
    private final Iterable<ServiceReference<Servlet>> servlets;
    private final Iterable<ServiceReference<Filter>> filters;
    private final MBeanServer mBeanServer;
    private Server server;

    public AbstractJettyMixin(String identity, Server jettyServer, Iterable<ServiceReference<ServletContextListener>> contextListeners, Iterable<ServiceReference<Servlet>> servlets, Iterable<ServiceReference<Filter>> filters, MBeanServer mBeanServer) {
        this.identity = identity;
        this.server = jettyServer;
        this.contextListeners = Iterables.unique(contextListeners);
        this.servlets = Iterables.unique(servlets);
        this.filters = Iterables.unique(filters);
        this.mBeanServer = mBeanServer;
    }

    @Override
    public final void startJetty() throws Exception {
        JettyConfigurationHelper.configureServer(this.server, this.configuration());
        HttpConfiguration httpConfig = new HttpConfiguration();
        JettyConfigurationHelper.configureHttp(httpConfig, this.configuration());
        httpConfig = this.specializeHttp(httpConfig);
        ServerConnector connector = this.buildConnector(this.server, httpConfig);
        JettyConfigurationHelper.configureConnector(connector, this.configuration());
        this.server.addConnector((Connector)connector);
        if (this.mBeanServer != null) {
            this.server.addEventListener((Container.Listener)new MBeanContainer(this.mBeanServer));
        }
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.server, "/", new SessionHandler(), this.buildSecurityHandler(), new ServletHandler(), new ErrorHandler());
        root.setDisplayName(this.identity);
        JettyConfigurationHelper.configureContext(root, this.configuration());
        JettyConfigurationHelper.addContextListeners(root, this.contextListeners);
        JettyConfigurationHelper.addServlets(root, this.servlets);
        JettyConfigurationHelper.addFilters(root, this.filters);
        this.server.start();
    }

    @Override
    public final void stopJetty() throws Exception {
        this.server.stop();
        for (Connector connector : this.server.getConnectors()) {
            connector.stop();
        }
        this.server = null;
    }

    @Override
    public final Interface[] interfacesServed() {
        Connector[] connectors = this.server.getConnectors();
        Interface[] result = new Interface[connectors.length];
        int index = 0;
        for (Connector connector : connectors) {
            if (!(connector instanceof NetworkConnector)) continue;
            NetworkConnector netConnector = (NetworkConnector)connector;
            String host = (String)this.configuration().hostName().get();
            if (host == null && (host = netConnector.getHost()) == null) {
                try {
                    host = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    InternalError error = new InternalError("UnknownHost for local interface.");
                    error.initCause(e);
                    throw error;
                }
            }
            result[index++] = new InterfaceImpl(host, netConnector.getPort(), this.servedProtocol());
        }
        return result;
    }

    protected abstract JettyConfiguration configuration();

    protected HttpConfiguration specializeHttp(HttpConfiguration httpConfig) {
        return httpConfig;
    }

    protected ServerConnector buildConnector(Server server, HttpConfiguration httpConfig) {
        return new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
    }

    protected SecurityHandler buildSecurityHandler() {
        return null;
    }

    protected abstract Interface.Protocol servedProtocol();
}

