/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.http;

import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.util.security.Constraint;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.http.ConstraintInfo;

@Mixins(value={Mixin.class})
public interface ConstraintService
extends ServiceComposite {
    public ConstraintMapping buildConstraintMapping();

    public static abstract class Mixin
    implements ConstraintService {
        @Service
        private ServiceReference<ConstraintService> myRef;

        @Override
        public ConstraintMapping buildConstraintMapping() {
            ConstraintMapping csMapping = null;
            ConstraintInfo constraintInfo = (ConstraintInfo)this.myRef.metaInfo(ConstraintInfo.class);
            if (constraintInfo != null && constraintInfo.getConstraint() != null) {
                Constraint constraint = new Constraint();
                switch (constraintInfo.getConstraint()) {
                    // Empty switch
                }
                csMapping = new ConstraintMapping();
                csMapping.setConstraint(constraint);
                csMapping.setPathSpec(constraintInfo.getPath());
                if (constraintInfo.getOmittedHttpMethods() != null && constraintInfo.getOmittedHttpMethods().length > 0) {
                    csMapping.setMethodOmissions(ConstraintInfo.HttpMethod.toStringArray(constraintInfo.getOmittedHttpMethods()));
                }
            }
            return csMapping;
        }
    }
}

