/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.http;

import java.security.Provider;
import java.security.Security;
import java.util.EventListener;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.ConnectorStatistics;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.qi4j.api.common.InvalidApplicationException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.http.ContextListenerInfo;
import org.qi4j.library.http.FilterInfo;
import org.qi4j.library.http.JettyConfiguration;
import org.qi4j.library.http.SecureJettyConfiguration;
import org.qi4j.library.http.ServletInfo;

final class JettyConfigurationHelper {
    private static final Integer DEFAULT_PORT = 8080;
    private static final String[] DEFAULT_WELCOME_FILES = new String[]{"index.html"};
    private static final String COMA = ",";

    static void configureServer(Server server, JettyConfiguration config) {
        Integer lowResourceMaxIdleTime;
        Integer gracefullShudownTimeout = (Integer)config.gracefullShutdownTimeout().get();
        if (gracefullShudownTimeout != null) {
            server.setStopTimeout((long)gracefullShudownTimeout.intValue());
        }
        if ((lowResourceMaxIdleTime = (Integer)config.lowResourceMaxIdleTime().get()) != null) {
            LowResourceMonitor lowResourceMonitor = new LowResourceMonitor(server);
            lowResourceMonitor.setLowResourcesIdleTimeout(lowResourceMaxIdleTime.intValue());
            server.addBean((Object)lowResourceMonitor);
        }
        if (((Boolean)config.statistics().get()).booleanValue()) {
            server.addBean((Object)new ConnectorStatistics());
        }
    }

    static void configureHttp(HttpConfiguration httpConfig, JettyConfiguration config) {
        Integer responseBufferSize;
        Integer responseHeaderSize;
        Integer requestHeaderSize;
        Boolean sendServerVersion;
        Boolean sendDateHeader = (Boolean)config.sendDateHeader().get();
        if (sendDateHeader != null) {
            httpConfig.setSendDateHeader(sendDateHeader.booleanValue());
        }
        if ((sendServerVersion = (Boolean)config.sendServerVersion().get()) != null) {
            httpConfig.setSendServerVersion(sendServerVersion.booleanValue());
        }
        if ((requestHeaderSize = (Integer)config.requestHeaderSize().get()) != null) {
            httpConfig.setRequestHeaderSize(requestHeaderSize.intValue());
        }
        if ((responseHeaderSize = (Integer)config.responseHeaderSize().get()) != null) {
            httpConfig.setResponseHeaderSize(responseHeaderSize.intValue());
        }
        if ((responseBufferSize = (Integer)config.responseBufferSize().get()) != null) {
            httpConfig.setOutputBufferSize(responseBufferSize.intValue());
        }
    }

    static void configureConnector(ServerConnector connector, JettyConfiguration config) {
        connector.setHost((String)config.hostName().get());
        Integer port = (Integer)config.port().get();
        if (port == null) {
            port = DEFAULT_PORT;
        }
        connector.setPort(port.intValue());
        Integer maxIdleTime = (Integer)config.maxIdleTime().get();
        if (maxIdleTime != null) {
            connector.setIdleTimeout((long)maxIdleTime.intValue());
        }
    }

    static void configureSsl(SslConnectionFactory sslConnFactory, SecureJettyConfiguration config) {
        Provider bc;
        Boolean cacheSslSessions;
        String[] cipherIncludes;
        String cipherIncludesConfigString;
        String[] cipherExcludes;
        String cipherExcludesConfigString;
        String secureRandomAlgo;
        Boolean need;
        Boolean want;
        SslContextFactory ssl = sslConnFactory.getSslContextFactory();
        boolean needBouncyCastle = false;
        String keystoreType = (String)config.keystoreType().get();
        String keystorePath = (String)config.keystorePath().get();
        String keystorePassword = (String)config.keystorePassword().get();
        ssl.setKeyStoreType(keystoreType);
        if ("PKCS12".equals(keystoreType)) {
            ssl.setKeyStoreProvider("BC");
            needBouncyCastle = true;
        }
        ssl.setKeyStorePath(keystorePath);
        ssl.setKeyStorePassword(keystorePassword);
        String certAlias = (String)config.certAlias().get();
        if (certAlias != null) {
            ssl.setCertAlias(certAlias);
        }
        String truststoreType = (String)config.truststoreType().get();
        String truststorePath = (String)config.truststorePath().get();
        String truststorePassword = (String)config.truststorePassword().get();
        if (truststoreType != null && truststorePath != null) {
            ssl.setTrustStoreType(truststoreType);
            if ("PKCS12".equals(truststoreType)) {
                ssl.setTrustStoreProvider("BC");
                needBouncyCastle = true;
            }
            ssl.setTrustStorePath(truststorePath);
            ssl.setTrustStorePassword(truststorePassword);
        }
        if ((want = (Boolean)config.wantClientAuth().get()) != null) {
            ssl.setWantClientAuth(want.booleanValue());
        }
        if ((need = (Boolean)config.needClientAuth().get()) != null) {
            ssl.setNeedClientAuth(need.booleanValue());
        }
        if ((secureRandomAlgo = (String)config.secureRandomAlgorithm().get()) != null) {
            ssl.setSecureRandomAlgorithm(secureRandomAlgo);
        }
        if ((cipherExcludesConfigString = (String)config.excludeCipherSuites().get()) != null && (cipherExcludes = cipherExcludesConfigString.split(COMA)).length > 0) {
            ssl.setExcludeCipherSuites(cipherExcludes);
        }
        if ((cipherIncludesConfigString = (String)config.includeCipherSuites().get()) != null && (cipherIncludes = cipherIncludesConfigString.split(COMA)).length > 0) {
            ssl.setIncludeCipherSuites(cipherIncludes);
        }
        if ((cacheSslSessions = (Boolean)config.cacheSslSessions().get()) != null) {
            ssl.setSessionCachingEnabled(cacheSslSessions.booleanValue());
        }
        ssl.setRenegotiationAllowed(((Boolean)config.allowRenegotiation().get()).booleanValue());
        Integer maxCertPathLength = (Integer)config.maxCertPathLength().get();
        if (maxCertPathLength != null) {
            ssl.setMaxCertPathLength(maxCertPathLength.intValue());
        }
        ssl.setValidateCerts(((Boolean)config.validateServerCert().get()).booleanValue());
        ssl.setValidatePeerCerts(((Boolean)config.validatePeerCerts().get()).booleanValue());
        String crlFilePath = (String)config.crlFilePath().get();
        if (crlFilePath != null && crlFilePath.length() > 0) {
            ssl.setCrlPath(crlFilePath);
        }
        ssl.setEnableCRLDP(((Boolean)config.enableCRLDP().get()).booleanValue());
        ssl.setEnableOCSP(((Boolean)config.enableOCSP().get()).booleanValue());
        String ocspURL = (String)config.ocspResponderURL().get();
        if (ocspURL != null) {
            ssl.setOcspResponderURL(ocspURL);
        }
        if (needBouncyCastle && (bc = Security.getProvider("BC")) == null) {
            try {
                Security.addProvider((Provider)Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance());
            }
            catch (Exception ex) {
                throw new InvalidApplicationException("Need to open a PKCS#12 but was unable to register BouncyCastle, check your classpath", (Throwable)ex);
            }
        }
    }

    static void configureContext(ServletContextHandler root, JettyConfiguration config) {
        String welcomeFilesConfigString;
        String[] virtualHosts;
        String virtualHostsConfigString;
        Integer maxFormContentSize;
        String resourcePath;
        String contextPath = (String)config.contextPath().get();
        if (contextPath != null && contextPath.length() > 0) {
            root.setContextPath(contextPath);
        }
        if ((resourcePath = (String)config.resourcePath().get()) != null && resourcePath.length() > 0) {
            root.addServlet(DefaultServlet.class, "/");
            root.setResourceBase(resourcePath);
        }
        if ((maxFormContentSize = (Integer)config.maxFormContentSize().get()) != null) {
            root.setMaxFormContentSize(maxFormContentSize.intValue());
        }
        if ((virtualHostsConfigString = (String)config.virtualHosts().get()) != null && (virtualHosts = virtualHostsConfigString.split(COMA)).length > 0) {
            root.setVirtualHosts(virtualHosts);
        }
        if ((welcomeFilesConfigString = (String)config.welcomeFiles().get()) == null) {
            root.setWelcomeFiles(DEFAULT_WELCOME_FILES);
        } else {
            String[] welcomeFiles = welcomeFilesConfigString.split(COMA);
            if (welcomeFiles.length == 0) {
                root.setWelcomeFiles(DEFAULT_WELCOME_FILES);
            } else {
                root.setWelcomeFiles(welcomeFiles);
            }
        }
    }

    static void addContextListeners(ServletContextHandler root, Iterable<ServiceReference<ServletContextListener>> contextListeners) {
        for (ServiceReference<ServletContextListener> contextListener : contextListeners) {
            ContextListenerInfo contextListenerInfo = (ContextListenerInfo)contextListener.metaInfo(ContextListenerInfo.class);
            Map<String, String> initParams = contextListenerInfo.initParams();
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                root.setInitParameter(entry.getKey(), entry.getValue());
            }
            root.addEventListener((EventListener)contextListener.get());
        }
    }

    static void addServlets(ServletContextHandler root, Iterable<ServiceReference<Servlet>> servlets) {
        for (ServiceReference<Servlet> servlet : servlets) {
            ServletInfo servletInfo = (ServletInfo)servlet.metaInfo(ServletInfo.class);
            String servletPath = servletInfo.getPath();
            Servlet servletInstance = (Servlet)servlet.get();
            ServletHolder holder = new ServletHolder(servletInstance);
            holder.setInitParameters(servletInfo.initParams());
            root.addServlet(holder, servletPath);
        }
    }

    static void addFilters(ServletContextHandler root, Iterable<ServiceReference<Filter>> filters) {
        for (ServiceReference<Filter> filter : filters) {
            FilterInfo filterInfo = (FilterInfo)filter.metaInfo(FilterInfo.class);
            String filterPath = filterInfo.getPath();
            Filter filterInstance = (Filter)filter.get();
            FilterHolder holder = new FilterHolder(filterInstance);
            holder.setInitParameters(filterInfo.initParameters());
            root.addFilter(holder, filterPath, filterInfo.dispatchers());
        }
    }

    private JettyConfigurationHelper() {
    }
}

