/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.http;

import org.qi4j.api.common.Optional;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.property.Property;
import org.qi4j.library.constraints.annotation.GreaterThan;
import org.qi4j.library.constraints.annotation.OneOf;
import org.qi4j.library.http.JettyConfiguration;

public interface SecureJettyConfiguration
extends JettyConfiguration {
    @OneOf(value={"PKCS12", "JCEKS", "JKS"})
    public Property<String> keystoreType();

    public Property<String> keystorePath();

    @UseDefaults
    public Property<String> keystorePassword();

    @Optional
    public Property<String> certAlias();

    @Optional
    @OneOf(value={"PKCS12", "JCEKS", "JKS"})
    public Property<String> truststoreType();

    @Optional
    public Property<String> truststorePath();

    @UseDefaults
    public Property<String> truststorePassword();

    @UseDefaults
    public Property<Boolean> wantClientAuth();

    @UseDefaults
    public Property<Boolean> needClientAuth();

    @Optional
    public Property<String> secureRandomAlgorithm();

    @Optional
    public Property<String> includeCipherSuites();

    @Optional
    public Property<String> excludeCipherSuites();

    @Optional
    public Property<Boolean> cacheSslSessions();

    @UseDefaults
    public Property<Boolean> allowRenegotiation();

    @Optional
    @GreaterThan(value=-2.0)
    public Property<Integer> maxCertPathLength();

    @UseDefaults
    public Property<Boolean> validateServerCert();

    @UseDefaults
    public Property<Boolean> validatePeerCerts();

    @Optional
    public Property<String> crlFilePath();

    @UseDefaults
    public Property<Boolean> enableCRLDP();

    @UseDefaults
    public Property<Boolean> enableOCSP();

    @Optional
    public Property<String> ocspResponderURL();
}

