/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.http;

import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.qi4j.api.common.Optional;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.http.AbstractJettyMixin;
import org.qi4j.library.http.ConstraintService;
import org.qi4j.library.http.Interface;
import org.qi4j.library.http.JettyConfiguration;
import org.qi4j.library.http.JettyConfigurationHelper;
import org.qi4j.library.http.SecureJettyConfiguration;

public class SecureJettyMixin
extends AbstractJettyMixin {
    @This
    private Configuration<SecureJettyConfiguration> configuration;
    @Optional
    @Service
    private Iterable<ConstraintService> constraintServices;

    public SecureJettyMixin(@This Identity meAsIdentity, @Service Server jettyServer, @Service Iterable<ServiceReference<ServletContextListener>> contextListeners, @Service Iterable<ServiceReference<Servlet>> servlets, @Service Iterable<ServiceReference<Filter>> filters, @Optional @Service MBeanServer mBeanServer) {
        super((String)meAsIdentity.identity().get(), jettyServer, contextListeners, servlets, filters, mBeanServer);
    }

    @Override
    protected JettyConfiguration configuration() {
        return (JettyConfiguration)this.configuration.get();
    }

    @Override
    protected HttpConfiguration specializeHttp(HttpConfiguration httpConfig) {
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return httpsConfig;
    }

    @Override
    protected SecurityHandler buildSecurityHandler() {
        if (this.constraintServices != null) {
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            for (ConstraintService eachConstraintService : this.constraintServices) {
                ConstraintMapping csMapping = eachConstraintService.buildConstraintMapping();
                if (csMapping == null) continue;
                securityHandler.addConstraintMapping(csMapping);
            }
            if (!securityHandler.getConstraintMappings().isEmpty()) {
                return securityHandler;
            }
        }
        return super.buildSecurityHandler();
    }

    @Override
    protected ServerConnector buildConnector(Server server, HttpConfiguration httpConfig) {
        SslConnectionFactory sslConnFactory = new SslConnectionFactory();
        JettyConfigurationHelper.configureSsl(sslConnFactory, (SecureJettyConfiguration)this.configuration.get());
        return new ServerConnector(server, new ConnectionFactory[]{sslConnFactory, new HttpConnectionFactory(httpConfig)});
    }

    @Override
    protected Interface.Protocol servedProtocol() {
        return Interface.Protocol.https;
    }
}

