/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.http;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.library.http.ConstraintInfo;
import org.qi4j.library.http.ConstraintService;
import org.qi4j.library.http.ContextListenerInfo;
import org.qi4j.library.http.Dispatchers;
import org.qi4j.library.http.FilterInfo;
import org.qi4j.library.http.ServletInfo;

public final class Servlets {
    private Servlets() {
    }

    public static ContextListenerDeclaration listen() {
        return new ContextListenerDeclaration();
    }

    public static ContextListenerAssembler addContextListeners(ContextListenerDeclaration ... contextListenerDeclarations) {
        return new ContextListenerAssembler(contextListenerDeclarations);
    }

    public static ServletDeclaration serve(String path) {
        return new ServletDeclaration(path);
    }

    public static ServletAssembler addServlets(ServletDeclaration ... servletDeclarations) {
        return new ServletAssembler(servletDeclarations);
    }

    public static FilterAssembler filter(String path) {
        return new FilterAssembler(path);
    }

    public static FilterDeclaration addFilters(FilterAssembler ... filterAssemblers) {
        return new FilterDeclaration(filterAssemblers);
    }

    public static ConstraintAssembler constrain(String path) {
        return new ConstraintAssembler(path);
    }

    public static ConstraintDeclaration addConstraints(ConstraintAssembler ... constraintAssemblers) {
        return new ConstraintDeclaration(constraintAssemblers);
    }

    public static class ConstraintAssembler {
        private final String path;
        private ConstraintInfo.Constraint constraint;
        private ConstraintInfo.HttpMethod[] omittedHttpMethods = new ConstraintInfo.HttpMethod[0];

        private ConstraintAssembler(String path) {
            this.path = path;
        }

        public ConstraintAssembler by(ConstraintInfo.Constraint constraint) {
            this.constraint = constraint;
            return this;
        }

        public ConstraintAssembler butNotOn(ConstraintInfo.HttpMethod ... omittedHttpMethods) {
            this.omittedHttpMethods = omittedHttpMethods;
            return this;
        }

        ConstraintInfo constraintInfo() {
            return new ConstraintInfo(this.path, this.constraint, this.omittedHttpMethods);
        }
    }

    public static class ConstraintDeclaration {
        private final ConstraintAssembler[] constraintAssemblers;

        private ConstraintDeclaration(ConstraintAssembler[] constraintAssemblers) {
            this.constraintAssemblers = constraintAssemblers;
        }

        public void to(ModuleAssembly module) throws AssemblyException {
            for (ConstraintAssembler eachAssembler : this.constraintAssemblers) {
                module.addServices(new Class[]{ConstraintService.class}).identifiedBy(UUID.randomUUID().toString()).setMetaInfo((Object)eachAssembler.constraintInfo());
            }
        }
    }

    public static class FilterAssembler {
        String path;
        Class<? extends ServiceComposite> filter;
        EnumSet<DispatcherType> dispatchers;
        Map<String, String> initParams = Collections.emptyMap();

        FilterAssembler(String path) {
            this.path = path;
        }

        public <T extends Filter & ServiceComposite> FilterAssembler through(Class<T> filter) {
            this.filter = filter;
            return this;
        }

        public FilterAssembler on(DispatcherType first, DispatcherType ... rest) {
            this.dispatchers = EnumSet.of(first, rest);
            return this;
        }

        @Deprecated
        public FilterAssembler on(Dispatchers.Dispatcher first, Dispatchers.Dispatcher ... rest) {
            EnumSet<DispatcherType> dispatch = EnumSet.noneOf(DispatcherType.class);
            for (Dispatchers.Dispatcher each : Dispatchers.dispatchers(first, rest)) {
                switch (each) {
                    case FORWARD: {
                        dispatch.add(DispatcherType.FORWARD);
                        break;
                    }
                    case REQUEST: {
                        dispatch.add(DispatcherType.REQUEST);
                    }
                }
            }
            this.dispatchers = dispatch;
            return this;
        }

        public FilterAssembler withInitParams(Map<String, String> initParams) {
            this.initParams = initParams;
            return this;
        }

        Class<? extends ServiceComposite> filter() {
            return this.filter;
        }

        FilterInfo filterInfo() {
            return new FilterInfo(this.path, this.initParams, this.dispatchers);
        }
    }

    public static class FilterDeclaration {
        final FilterAssembler[] filterAssemblers;

        FilterDeclaration(FilterAssembler ... filterAssemblers) {
            this.filterAssemblers = filterAssemblers;
        }

        public void to(ModuleAssembly module) throws AssemblyException {
            for (FilterAssembler filterAssembler : this.filterAssemblers) {
                module.services(new Class[]{filterAssembler.filter()}).setMetaInfo((Object)filterAssembler.filterInfo()).instantiateOnStartup().visibleIn(Visibility.layer);
            }
        }
    }

    public static class ServletDeclaration {
        String path;
        Class<? extends ServiceComposite> servlet;
        Map<String, String> initParams = Collections.emptyMap();

        ServletDeclaration(String path) {
            this.path = path;
        }

        public <T extends Servlet & ServiceComposite> ServletDeclaration with(Class<T> servlet) {
            this.servlet = servlet;
            return this;
        }

        public ServletDeclaration withInitParams(Map<String, String> initParams) {
            this.initParams = initParams;
            return this;
        }

        Class<? extends ServiceComposite> servlet() {
            return this.servlet;
        }

        ServletInfo servletInfo() {
            return new ServletInfo(this.path, this.initParams);
        }
    }

    public static class ServletAssembler {
        final ServletDeclaration[] servletDeclarations;

        ServletAssembler(ServletDeclaration ... servletDeclarations) {
            this.servletDeclarations = servletDeclarations;
        }

        public void to(ModuleAssembly module) throws AssemblyException {
            for (ServletDeclaration servletDeclaration : this.servletDeclarations) {
                module.services(new Class[]{servletDeclaration.servlet()}).setMetaInfo((Object)servletDeclaration.servletInfo()).instantiateOnStartup().visibleIn(Visibility.layer);
            }
        }
    }

    public static class ContextListenerDeclaration {
        Class<? extends ServiceComposite> contextListener;
        Map<String, String> initParams = Collections.emptyMap();

        public <T extends ServletContextListener & ServiceComposite> ContextListenerDeclaration with(Class<T> contextListener) {
            this.contextListener = contextListener;
            return this;
        }

        public Class<? extends ServiceComposite> contextListener() {
            return this.contextListener;
        }

        public ContextListenerDeclaration withInitParams(Map<String, String> initParams) {
            this.initParams = initParams;
            return this;
        }

        private ContextListenerInfo contextListenerInfo() {
            return new ContextListenerInfo(this.initParams);
        }
    }

    public static class ContextListenerAssembler {
        final ContextListenerDeclaration[] contextListenerDeclarations;

        ContextListenerAssembler(ContextListenerDeclaration ... eventListenerDeclarations) {
            this.contextListenerDeclarations = eventListenerDeclarations;
        }

        public void to(ModuleAssembly module) throws AssemblyException {
            for (ContextListenerDeclaration contextListenerDeclaration : this.contextListenerDeclarations) {
                module.services(new Class[]{contextListenerDeclaration.contextListener()}).setMetaInfo((Object)contextListenerDeclaration.contextListenerInfo()).instantiateOnStartup().visibleIn(Visibility.layer);
            }
        }
    }
}

