/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.valueserialization.stax;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueDeserializer;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.functional.Function;
import org.qi4j.spi.value.ValueDeserializerAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StaxValueDeserializer
extends ValueDeserializerAdapter<XMLEventReader, Node> {
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public StaxValueDeserializer(@Structure Application application, @Structure Module module, @Service ServiceReference<ValueDeserializer> serviceRef) {
        super(application, module, serviceRef);
        this.inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
    }

    protected XMLEventReader adaptInput(InputStream input) throws Exception {
        return this.inputFactory.createXMLEventReader(input, "UTF-8");
    }

    protected Object readPlainValue(XMLEventReader input) throws Exception {
        if (!input.hasNext()) {
            return null;
        }
        XMLEvent nextEvent = input.nextEvent();
        if (nextEvent.getEventType() == 1 && "null".equals(nextEvent.asStartElement().getName().getLocalPart())) {
            input.nextTag();
            return null;
        }
        if (nextEvent.getEventType() != 4) {
            throw new ValueSerializationException("Expected characters but got: " + nextEvent);
        }
        String stringValue = nextEvent.asCharacters().getData();
        return this.detectAndConvertStringValue(stringValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected <T> Collection<T> readArrayInCollection(XMLEventReader input, Function<XMLEventReader, T> deserializer, Collection<T> collection) throws Exception {
        if (!input.hasNext()) {
            return null;
        }
        XMLEvent nextTag = input.nextTag();
        if (nextTag.isStartElement() && "null".equals(nextTag.asStartElement().getName().getLocalPart())) {
            input.nextTag();
            return null;
        }
        if (!nextTag.isStartElement()) throw new ValueSerializationException("Expected an <array/> but got: " + nextTag);
        if (!"array".equals(nextTag.asStartElement().getName().getLocalPart())) {
            throw new ValueSerializationException("Expected an <array/> but got: " + nextTag);
        }
        block8: while (input.hasNext()) {
            XMLEvent currentTag = input.nextTag();
            if (currentTag.isEndElement()) {
                String endElementName;
                switch (endElementName = currentTag.asEndElement().getName().getLocalPart()) {
                    case "array": {
                        return collection;
                    }
                    case "value": {
                        continue block8;
                    }
                }
            }
            if (!"value".equals(currentTag.asStartElement().getName().getLocalPart())) {
                throw new ValueSerializationException("Expected a <value/> but got: " + currentTag);
            }
            Object item = deserializer.map((Object)input);
            collection.add(item);
        }
        return collection;
    }

    protected <K, V> Map<K, V> readMapInMap(XMLEventReader input, Function<XMLEventReader, K> keyDeserializer, Function<XMLEventReader, V> valueDeserializer, Map<K, V> map) throws Exception {
        if (!input.hasNext()) {
            return null;
        }
        XMLEvent nextTag = input.nextTag();
        if (nextTag.isStartElement() && "null".equals(nextTag.asStartElement().getName().getLocalPart())) {
            input.nextTag();
            return null;
        }
        if (!nextTag.isStartElement() || !"array".equals(nextTag.asStartElement().getName().getLocalPart())) {
            throw new ValueSerializationException("Expected an <array/> but got: " + nextTag);
        }
        XMLEvent currentTag = input.nextTag();
        while (!currentTag.isEndElement() || !"array".equals(currentTag.asEndElement().getName().getLocalPart())) {
            if (!currentTag.isStartElement() || !"object".equals(currentTag.asStartElement().getName().getLocalPart())) {
                throw new ValueSerializationException("Expected an <object/> but got: " + nextTag);
            }
            currentTag = input.nextTag();
            Object key = null;
            Object value = null;
            while (!currentTag.isEndElement() || !"object".equals(currentTag.asEndElement().getName().getLocalPart())) {
                input.nextTag();
                String keyOrValue = input.nextEvent().asCharacters().getData();
                input.nextTag();
                input.nextTag();
                switch (keyOrValue) {
                    case "key": {
                        key = keyDeserializer.map((Object)input);
                        break;
                    }
                    case "value": {
                        value = valueDeserializer.map((Object)input);
                        break;
                    }
                    default: {
                        this.readObjectTree(input);
                    }
                }
                input.nextTag();
                input.nextTag();
                currentTag = input.nextTag();
            }
            if (key != null) {
                map.put(key, value);
            }
            currentTag = input.nextTag();
        }
        return map;
    }

    protected Node readObjectTree(XMLEventReader input) throws Exception {
        XMLEvent peek = input.peek();
        if (peek.isStartElement() && "null".equals(peek.asStartElement().getName().getLocalPart())) {
            input.nextTag();
            input.nextTag();
            return null;
        }
        String elementBody = StaxValueDeserializer.readElementBody(input);
        Transformer transformer = this.transformerFactory.newTransformer();
        DOMResult domResult = new DOMResult();
        transformer.transform(new StreamSource(new StringReader(elementBody)), domResult);
        return ((Document)domResult.getNode()).getDocumentElement();
    }

    private static String readElementBody(XMLEventReader input) throws XMLStreamException {
        StringWriter buf = new StringWriter(1024);
        int depth = 0;
        while (input.hasNext()) {
            XMLEvent xmlEvent = input.peek();
            if (xmlEvent.isStartElement()) {
                ++depth;
            } else if (xmlEvent.isEndElement() && --depth < 0) break;
            xmlEvent = input.nextEvent();
            xmlEvent.writeAsEncodedUnicode(buf);
        }
        return buf.getBuffer().toString();
    }

    protected Object asSimpleValue(Node inputNode) throws Exception {
        if (inputNode == null) {
            return null;
        }
        if (inputNode.getNodeType() == 1 && "null".equals(inputNode.getLocalName())) {
            return null;
        }
        if (inputNode.getNodeType() != 3 && inputNode.getNodeType() != 4) {
            throw new ValueSerializationException("Expected a TEXT or CDATA node but got " + inputNode);
        }
        String stringValue = inputNode.getNodeValue();
        return this.detectAndConvertStringValue(stringValue);
    }

    protected boolean isObjectValue(Node inputNode) throws Exception {
        if (inputNode == null) {
            return false;
        }
        if ("object".equals(inputNode.getLocalName())) {
            return true;
        }
        if (!"value".equals(inputNode.getLocalName())) {
            return false;
        }
        return StaxValueDeserializer.getDirectChildNode(inputNode, "object") != null;
    }

    protected boolean objectHasField(Node inputNode, String key) throws Exception {
        if (inputNode == null) {
            return false;
        }
        Node objectNode = "value".equals(inputNode.getLocalName()) ? StaxValueDeserializer.getDirectChildNode(inputNode, "object") : inputNode;
        if (objectNode == null) {
            return false;
        }
        if (!"object".equals(objectNode.getLocalName())) {
            throw new ValueSerializationException("Expected an object value but got: " + objectNode);
        }
        return StaxValueDeserializer.getObjectFieldNode(objectNode, key) != null;
    }

    protected <T> T getObjectFieldValue(Node inputNode, String key, Function<Node, T> valueDeserializer) throws Exception {
        if (inputNode == null) {
            return null;
        }
        Node objectNode = "value".equals(inputNode.getLocalName()) ? StaxValueDeserializer.getDirectChildNode(inputNode, "object") : inputNode;
        if (objectNode == null) {
            return null;
        }
        if (!"object".equals(objectNode.getLocalName())) {
            throw new ValueSerializationException("Expected an object value but got: " + objectNode);
        }
        Node fieldNode = StaxValueDeserializer.getObjectFieldNode(objectNode, key);
        if (fieldNode == null) {
            return null;
        }
        Node valueElement = StaxValueDeserializer.getDirectChildNode(fieldNode, "value");
        Node valueNode = valueElement.getFirstChild();
        if (valueNode == null) {
            return (T)"";
        }
        if (valueNode.getNodeType() == 1 && "null".equals(valueNode.getLocalName())) {
            return null;
        }
        Object value = valueDeserializer.map((Object)valueNode);
        return (T)value;
    }

    protected <T> void putArrayNodeInCollection(Node inputNode, Function<Node, T> deserializer, Collection<T> collection) throws Exception {
        if (inputNode == null) {
            return;
        }
        if (!(inputNode instanceof Element)) {
            throw new ValueSerializationException("Expected an Element but got " + inputNode);
        }
        NodeList arrayValues = inputNode.getChildNodes();
        for (int arrayValuesIndex = 0; arrayValuesIndex < arrayValues.getLength(); ++arrayValuesIndex) {
            Node arrayValue = arrayValues.item(arrayValuesIndex);
            Object value = deserializer.map((Object)arrayValue.getFirstChild());
            collection.add(value);
        }
    }

    protected <K, V> void putArrayNodeInMap(Node inputNode, Function<Node, K> keyDeserializer, Function<Node, V> valueDeserializer, Map<K, V> map) throws Exception {
        if (inputNode == null) {
            return;
        }
        if (!"array".equals(inputNode.getLocalName())) {
            throw new ValueSerializationException("Expected an <array/> but got " + inputNode);
        }
        NodeList entriesNodes = inputNode.getChildNodes();
        for (int idx = 0; idx < entriesNodes.getLength(); ++idx) {
            Node entryNode = entriesNodes.item(idx);
            K key = this.getObjectFieldValue(entryNode, "key", keyDeserializer);
            V value = this.getObjectFieldValue(entryNode, "value", valueDeserializer);
            if (key == null) continue;
            map.put(key, value);
        }
    }

    protected <V> void putObjectNodeInMap(Node inputNode, Function<Node, V> valueDeserializer, Map<String, V> map) throws Exception {
        if (inputNode == null) {
            return;
        }
        if (!"object".equals(inputNode.getLocalName())) {
            throw new ValueSerializationException("Expected an <object/> but got " + inputNode);
        }
        NodeList fieldsNodes = inputNode.getChildNodes();
        for (int idx = 0; idx < fieldsNodes.getLength(); ++idx) {
            Node fieldNode = fieldsNodes.item(idx);
            String key = StaxValueDeserializer.getDirectChildNode(fieldNode, "name").getTextContent();
            if (key == null || key.length() <= 0) continue;
            V value = this.getObjectFieldValue(inputNode, key, valueDeserializer);
            map.put(key, value);
        }
    }

    private Object detectAndConvertStringValue(String stringValue) {
        if (stringValue == null || stringValue.length() == 0) {
            return "";
        }
        if ((stringValue = StringEscapeUtils.unescapeXml((String)stringValue)).matches("[+-]?\\d+(\\.\\d+)?([eE][+-]?\\d+(\\.\\d+)?)?")) {
            if (stringValue.indexOf(46) != -1) {
                return new BigDecimal(stringValue);
            }
            return new BigInteger(stringValue);
        }
        if ("true".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
            return Boolean.parseBoolean(stringValue);
        }
        return stringValue;
    }

    private static Node getObjectFieldNode(Node inputNode, String key) {
        if (inputNode == null) {
            return null;
        }
        if (!(inputNode instanceof Element)) {
            throw new ValueSerializationException("Excpected an Element but got " + inputNode);
        }
        NodeList fieldNodes = inputNode.getChildNodes();
        for (int idx = 0; idx < fieldNodes.getLength(); ++idx) {
            Node fieldNode = fieldNodes.item(idx);
            Node nameNode = StaxValueDeserializer.getDirectChildNode(fieldNode, "name");
            if (nameNode == null || !key.equals(nameNode.getTextContent())) continue;
            return fieldNode;
        }
        return null;
    }

    private static Node getDirectChildNode(Node parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!name.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }
}

