/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.valueserialization.stax;

import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.qi4j.spi.value.ValueSerializerAdapter;

public class StaxValueSerializer
extends ValueSerializerAdapter<XMLStreamWriter> {
    private final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();

    public StaxValueSerializer() {
        this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
    }

    protected XMLStreamWriter adaptOutput(OutputStream output) throws Exception {
        XMLStreamWriter xmlStreamWriter = this.outputFactory.createXMLStreamWriter(output, "UTF-8");
        xmlStreamWriter.writeStartDocument("utf-8", "1.1");
        return xmlStreamWriter;
    }

    protected void onSerializationEnd(Object object, XMLStreamWriter output) throws Exception {
        output.writeEndDocument();
        output.flush();
        output.close();
    }

    protected void onArrayStart(XMLStreamWriter output) throws Exception {
        output.writeStartElement("array");
    }

    protected void onArrayEnd(XMLStreamWriter output) throws Exception {
        output.writeEndElement();
    }

    protected void onObjectStart(XMLStreamWriter output) throws Exception {
        output.writeStartElement("object");
    }

    protected void onObjectEnd(XMLStreamWriter output) throws Exception {
        output.writeEndElement();
    }

    protected void onFieldStart(XMLStreamWriter output, String key) throws Exception {
        output.writeStartElement("field");
        output.writeStartElement("name");
        output.writeCharacters(key);
        output.writeEndElement();
    }

    protected void onFieldEnd(XMLStreamWriter output) throws Exception {
        output.writeEndElement();
    }

    protected void onValueStart(XMLStreamWriter output) throws Exception {
        output.writeStartElement("value");
    }

    protected void onValue(XMLStreamWriter output, Object value) throws Exception {
        if (value == null) {
            output.writeStartElement("null");
            output.writeEndElement();
        } else {
            output.writeCharacters(StringEscapeUtils.escapeXml((String)value.toString()));
        }
    }

    protected void onValueEnd(XMLStreamWriter output) throws Exception {
        output.writeEndElement();
    }
}

