/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.lang.javascript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.qi4j.api.common.AppliesToFilter;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.TransientBuilderFactory;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.library.scripting.ScriptException;
import org.qi4j.library.scripting.ScriptReloadable;

@org.qi4j.api.common.AppliesTo(value={AppliesTo.class})
public class JavaScriptMixin
implements InvocationHandler,
ScriptReloadable {
    @This
    private Composite me;
    private static Scriptable standardScope;
    private HashMap<String, Function> cachedScripts = new HashMap();
    @Structure
    private TransientBuilderFactory factory;
    private Scriptable instanceScope;

    public JavaScriptMixin() {
        Context cx = Context.enter();
        this.instanceScope = cx.newObject(standardScope);
        this.instanceScope.setPrototype(standardScope);
        Context.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Context cx = Context.enter();
        try {
            Scriptable proxyScope = Context.toObject((Object)proxy, (Scriptable)this.instanceScope);
            proxyScope.setPrototype(this.instanceScope);
            proxyScope.put("compositeBuilderFactory", proxyScope, (Object)this.factory);
            proxyScope.put("This", proxyScope, (Object)this.me);
            Function fn = this.getFunction(cx, proxyScope, method);
            Object result = fn.call(cx, this.instanceScope, proxyScope, args);
            if (result instanceof Undefined) {
                Object var8_8 = null;
                return var8_8;
            }
            if (result instanceof Wrapper) {
                Object object = ((Wrapper)result).unwrap();
                return object;
            }
            Object object = result;
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public void reloadScripts() {
        this.cachedScripts.clear();
    }

    private Function getFunction(Context cx, Scriptable scope, Method method) throws IOException {
        Class<?> declaringClass = method.getDeclaringClass();
        String classname = declaringClass.getName();
        String methodName = method.getName();
        String requestedFunctionName = classname + ":" + methodName;
        Function fx = this.cachedScripts.get(requestedFunctionName);
        if (fx != null) {
            return fx;
        }
        this.compileScripts(cx, scope, method);
        fx = this.cachedScripts.get(requestedFunctionName);
        return fx;
    }

    private void compileScripts(Context cx, Scriptable scope, Method method) throws IOException {
        URL scriptUrl = JavaScriptMixin.getFunctionResource(method);
        if (scriptUrl == null) {
            throw new IOException("No script found for method " + method.getName());
        }
        InputStream in = scriptUrl.openStream();
        BufferedReader scriptReader = new BufferedReader(new InputStreamReader(in));
        int lineNo = 1;
        String classname = method.getDeclaringClass().getName();
        while (true) {
            ScriptFragment fragment = this.extractFunction(scriptReader);
            if ("".equals(fragment.script.trim())) break;
            String functionName = this.parseFunctionName(fragment.script, scriptUrl.toString());
            Function function = cx.compileFunction(scope, fragment.script, "<" + scriptUrl.toString() + ">", lineNo, null);
            this.cachedScripts.put(classname + ":" + functionName, function);
            lineNo += fragment.numberOfLines;
        }
    }

    private String parseFunctionName(String script, String scriptName) {
        StringTokenizer st = new StringTokenizer(script, " \t\n\r\f(){}", false);
        if (!st.hasMoreTokens()) {
            throw new ScriptException("The word \"function\" was not found in script: " + scriptName);
        }
        String fx = st.nextToken();
        if (!"function".equals(fx)) {
            throw new ScriptException("The word \"function\" was not found in script: " + scriptName);
        }
        if (!st.hasMoreTokens()) {
            throw new ScriptException("Invalid syntax in: " + scriptName + "\n No function name.");
        }
        return st.nextToken();
    }

    private ScriptFragment extractFunction(Reader scriptReader) throws IOException {
        ScriptFragment fragment = new ScriptFragment();
        boolean inString = false;
        boolean inChar = false;
        boolean escaped = false;
        boolean lineComment = false;
        boolean blockComment = false;
        char lastCh = '\u0000';
        int braceCounter = 0;
        boolean notStarted = true;
        int b = scriptReader.read();
        int skip = 0;
        while (b != -1 && (notStarted || braceCounter > 0)) {
            char ch = (char)b;
            if (!blockComment && !lineComment) {
                fragment.script = fragment.script + ch;
                if (!escaped) {
                    if (!inString && !inChar) {
                        if (ch == '{') {
                            ++braceCounter;
                            notStarted = false;
                        }
                        if (ch == '}') {
                            --braceCounter;
                        }
                    }
                    if (ch == '\"') {
                        boolean bl = inString = !inString;
                    }
                    if (ch == '\'') {
                        boolean bl = inChar = !inChar;
                    }
                    if (ch == '\\') {
                        escaped = true;
                    }
                    if (ch == '\n') {
                        ++fragment.numberOfLines;
                    }
                    if (ch == '/' && lastCh == '/') {
                        lineComment = true;
                        fragment.script = fragment.script.substring(0, fragment.script.length() - 2);
                    }
                    if (ch == '*' && lastCh == '/') {
                        blockComment = true;
                        fragment.script = fragment.script.substring(0, fragment.script.length() - 2);
                    }
                } else if (ch == 'u') {
                    skip = 4;
                } else if (skip > 0) {
                    --skip;
                } else {
                    escaped = false;
                }
            } else {
                if (lineComment && ch == '\n') {
                    lineComment = false;
                }
                if (blockComment && ch == '/' && lastCh == '*') {
                    blockComment = false;
                }
            }
            lastCh = ch;
            b = scriptReader.read();
        }
        return fragment;
    }

    private static URL getFunctionResource(Method method) {
        String scriptName = JavaScriptMixin.getScriptName(method);
        Class<?> declaringClass = method.getDeclaringClass();
        ClassLoader loader = declaringClass.getClassLoader();
        return loader.getResource(scriptName);
    }

    private static String getScriptName(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        String classname = declaringClass.getName();
        return classname.replace('.', '/') + ".js";
    }

    static {
        Context cx = Context.enter();
        standardScope = cx.initStandardObjects();
        Context.exit();
    }

    public static class AppliesTo
    implements AppliesToFilter {
        public boolean appliesTo(Method method, Class compositeType, Class mixin, Class modelClass) {
            return JavaScriptMixin.getFunctionResource(method) != null;
        }
    }

    private static class ScriptFragment {
        String script = "";
        int numberOfLines = 0;

        private ScriptFragment() {
        }
    }
}

