/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.cache.memcache;

import java.util.concurrent.atomic.AtomicInteger;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.qi4j.spi.cache.Cache;

class MemcacheImpl<T>
implements Cache<T> {
    private static final AtomicInteger INSTANCES = new AtomicInteger();
    private final MemcachedClient client;
    private final String cacheId;
    private final String cachePrefix;
    private final Class<T> valueType;
    private final int expiration;
    private int refCount;

    MemcacheImpl(MemcachedClient client, String cacheId, Class<T> valueType, int expiration) {
        this.client = client;
        this.cacheId = cacheId;
        this.cachePrefix = cacheId + "." + INSTANCES.incrementAndGet() + ".";
        this.valueType = valueType;
        this.expiration = expiration;
    }

    public T get(String key) {
        Object value = this.client.get(this.prefix(key), (Transcoder)new SerializingTranscoder());
        this.client.touch(this.prefix(key), this.expiration);
        if (value == null) {
            return null;
        }
        return this.valueType.cast(value);
    }

    public T remove(String key) {
        String prefixedKey = this.prefix(key);
        Object old = this.client.get(prefixedKey, (Transcoder)new SerializingTranscoder());
        if (old != null) {
            this.client.delete(prefixedKey);
        }
        return this.valueType.cast(old);
    }

    public void put(String key, T value) {
        this.client.set(this.prefix(key), this.expiration, value, (Transcoder)new SerializingTranscoder());
    }

    public boolean exists(String key) {
        return this.client.get(this.prefix(key)) != null;
    }

    private String prefix(String key) {
        return this.cachePrefix + key;
    }

    synchronized void decRefCount() {
        --this.refCount;
    }

    synchronized void incRefCount() {
        ++this.refCount;
    }

    synchronized boolean isNotUsed() {
        return this.refCount == 0;
    }

    public String cacheId() {
        return this.cacheId;
    }
}

