/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.cache.memcache;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.qi4j.api.common.Optional;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.cache.memcache.MemcacheConfiguration;
import org.qi4j.cache.memcache.MemcacheImpl;
import org.qi4j.cache.memcache.MemcachePoolService;
import org.qi4j.spi.cache.Cache;

public class MemcachePoolMixin
implements MemcachePoolService {
    private final Map<String, MemcacheImpl<?>> caches = new HashMap();
    @This
    @Optional
    private Configuration<MemcacheConfiguration> configuration;
    private MemcachedClient client;
    private int expiration;

    public void activateService() throws Exception {
        if (this.configuration != null) {
            MemcacheConfiguration config = (MemcacheConfiguration)this.configuration.get();
            this.expiration = config.expiration().get() == null ? 3600 : (Integer)config.expiration().get();
            String addresses = config.addresses().get() == null ? "localhost:11211" : (String)config.addresses().get();
            ConnectionFactoryBuilder.Protocol protocol = config.protocol().get() == null ? ConnectionFactoryBuilder.Protocol.TEXT : ConnectionFactoryBuilder.Protocol.valueOf((String)((String)config.protocol().get()).toUpperCase());
            String username = (String)config.username().get();
            String password = (String)config.password().get();
            String authMech = config.authMechanism().get() == null ? "PLAIN" : (String)config.authMechanism().get();
            ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder();
            builder.setProtocol(protocol);
            if (username != null && !username.isEmpty()) {
                builder.setAuthDescriptor(new AuthDescriptor(new String[]{authMech}, (CallbackHandler)new PlainCallbackHandler(username, password)));
            }
            this.client = new MemcachedClient(builder.build(), AddrUtil.getAddresses((String)addresses));
        }
    }

    public void passivateService() throws Exception {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Cache<T> fetchCache(String cacheId, Class<T> valueType) {
        NullArgumentException.validateNotEmpty((String)"cacheId", (String)cacheId);
        Map<String, MemcacheImpl<?>> map = this.caches;
        synchronized (map) {
            MemcacheImpl<Object> cache = this.caches.get(cacheId);
            if (cache == null) {
                cache = new MemcacheImpl<T>(this.client, cacheId, valueType, this.expiration);
                this.caches.put(cacheId, cache);
            }
            cache.incRefCount();
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnCache(Cache<?> cache) {
        MemcacheImpl memcache = (MemcacheImpl)cache;
        memcache.decRefCount();
        Map<String, MemcacheImpl<?>> map = this.caches;
        synchronized (map) {
            if (memcache.isNotUsed()) {
                this.caches.remove(memcache.cacheId());
            }
        }
    }
}

