/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Initializable;
import org.qi4j.api.mixin.InitializationException;
import org.qi4j.api.structure.Module;
import org.qi4j.library.rest.client.spi.ResponseReader;
import org.restlet.Response;
import org.restlet.representation.Representation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseReaderDelegator
implements ResponseReader,
Initializable {
    List<ResponseReader> responseReaders = new ArrayList<ResponseReader>();
    @Structure
    private Module module;

    public void initialize() throws InitializationException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        ResourceBundle defaultResponseReaders = ResourceBundle.getBundle("org.qi4j.library.rest.client.rest-client");
        String responseReaderClasses = defaultResponseReaders.getString("responsereaders");
        logger.info("Using responsereaders:" + responseReaderClasses);
        for (String className : responseReaderClasses.split(",")) {
            try {
                Class<?> readerClass = this.module.classLoader().loadClass(className.trim());
                ResponseReader reader = (ResponseReader)this.module.newObject(readerClass, new Object[0]);
                this.registerResponseReader(reader);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not register response reader " + className, (Throwable)e);
            }
        }
    }

    public void registerResponseReader(ResponseReader reader) {
        this.responseReaders.add(reader);
    }

    @Override
    public Object readResponse(Response response, Class<?> resultType) {
        if (resultType.equals(Representation.class)) {
            return response.getEntity();
        }
        for (ResponseReader responseReader : this.responseReaders) {
            Object result = responseReader.readResponse(response, resultType);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

