/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client.api;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.util.Classes;
import org.qi4j.library.rest.client.api.ContextResourceClientFactory;
import org.qi4j.library.rest.client.api.HandlerCommand;
import org.qi4j.library.rest.client.spi.NullResponseHandler;
import org.qi4j.library.rest.client.spi.ResponseHandler;
import org.qi4j.library.rest.client.spi.ResultHandler;
import org.qi4j.library.rest.common.Resource;
import org.qi4j.library.rest.common.link.Link;
import org.qi4j.library.rest.common.link.LinksUtil;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.ObjectRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.security.User;

public class ContextResourceClient {
    @Uses
    private ContextResourceClientFactory contextResourceFactory;
    @Uses
    private Reference reference;
    private Resource resource;
    private ResponseHandler errorHandler = NullResponseHandler.INSTANCE;
    private ResponseHandler resourceHandler = NullResponseHandler.INSTANCE;
    private ResponseHandler deleteHandler = NullResponseHandler.INSTANCE;
    private Map<String, ResponseHandler> queryHandlers = new HashMap<String, ResponseHandler>();
    private Map<String, ResponseHandler> commandHandlers = new HashMap<String, ResponseHandler>();
    private Map<String, ResponseHandler> processingErrorHandlers = new HashMap<String, ResponseHandler>();

    public ContextResourceClient onError(ResponseHandler handler) {
        this.errorHandler = handler;
        return this;
    }

    public <T> ContextResourceClient onResource(final ResultHandler<T> handler) {
        this.resourceHandler = new ResponseHandler(){

            @Override
            public HandlerCommand handleResponse(Response response, ContextResourceClient client) {
                Class resultType = (Class)Classes.RAW_CLASS.map((Object)((ParameterizedType)handler.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]);
                Object result = ContextResourceClient.this.contextResourceFactory.readResponse(response, resultType);
                if (result instanceof Resource) {
                    ContextResourceClient.this.resource = (Resource)result;
                }
                return handler.handleResult(result, client);
            }
        };
        return this;
    }

    public ContextResourceClient onQuery(String relation, ResponseHandler handler) {
        this.queryHandlers.put(relation, handler);
        return this;
    }

    public <T> ContextResourceClient onQuery(String relation, final ResultHandler<T> handler) {
        final Class resultType = (Class)Classes.RAW_CLASS.map((Object)((ParameterizedType)handler.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]);
        this.queryHandlers.put(relation, new ResponseHandler(){

            @Override
            public HandlerCommand handleResponse(Response response, ContextResourceClient client) {
                Object result = ContextResourceClient.this.contextResourceFactory.readResponse(response, resultType);
                return handler.handleResult(result, client);
            }
        });
        return this;
    }

    public ContextResourceClient onCommand(String relation, ResponseHandler handler) {
        this.commandHandlers.put(relation, handler);
        return this;
    }

    public <T> ContextResourceClient onCommand(String relation, final ResultHandler<T> handler) {
        final Class resultType = (Class)Classes.RAW_CLASS.map((Object)((ParameterizedType)handler.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]);
        this.commandHandlers.put(relation, new ResponseHandler(){

            @Override
            public HandlerCommand handleResponse(Response response, ContextResourceClient client) {
                Object result = ContextResourceClient.this.contextResourceFactory.readResponse(response, resultType);
                return handler.handleResult(result, client);
            }
        });
        return this;
    }

    public ContextResourceClient onProcessingError(String relation, ResponseHandler handler) {
        this.processingErrorHandlers.put(relation, handler);
        return this;
    }

    public <T> ContextResourceClient onProcessingError(String relation, final ResultHandler<T> handler) {
        final Class resultType = (Class)Classes.RAW_CLASS.map((Object)((ParameterizedType)handler.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]);
        this.processingErrorHandlers.put(relation, new ResponseHandler(){

            @Override
            public HandlerCommand handleResponse(Response response, ContextResourceClient client) {
                Object result = ContextResourceClient.this.contextResourceFactory.readResponse(response, resultType);
                return handler.handleResult(result, client);
            }
        });
        return this;
    }

    public ContextResourceClient onDelete(ResponseHandler handler) {
        this.deleteHandler = handler;
        return this;
    }

    public ContextResourceClientFactory getContextResourceClientFactory() {
        return this.contextResourceFactory;
    }

    public Reference getReference() {
        return this.reference;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void start() {
        for (HandlerCommand command = this.refresh(); command != null; command = command.execute(this)) {
        }
    }

    HandlerCommand refresh() {
        if (this.resourceHandler == null) {
            throw new IllegalStateException("No handler set for resources");
        }
        return this.invokeQuery(this.reference, null, this.resourceHandler, null);
    }

    HandlerCommand query(String relation, Object queryRequest, ResponseHandler handler, ResponseHandler processingErrorHandler) {
        return this.query(this.resource.query(relation), queryRequest, handler, processingErrorHandler);
    }

    HandlerCommand query(Link link, Object queryRequest, ResponseHandler handler, ResponseHandler processingErrorHandler) {
        Reference linkRef;
        if (handler == null) {
            handler = this.queryHandlers.get(link.rel().get());
        }
        if (handler == null) {
            throw new IllegalArgumentException("No handler set for relation " + (String)link.rel().get());
        }
        if (processingErrorHandler == null) {
            processingErrorHandler = this.processingErrorHandlers.get(link.rel().get());
        }
        if ((linkRef = new Reference((String)link.href().get())).isRelative()) {
            linkRef = new Reference(this.reference.toUri().toString() + (String)link.href().get());
        }
        return this.invokeQuery(linkRef, queryRequest, handler, processingErrorHandler);
    }

    private HandlerCommand invokeQuery(Reference ref, Object queryRequest, ResponseHandler resourceHandler, ResponseHandler processingErrorHandler) {
        Request request = new Request(Method.GET, ref);
        if (queryRequest != null) {
            this.contextResourceFactory.writeRequest(request, queryRequest);
        }
        this.contextResourceFactory.updateQueryRequest(request);
        User user = request.getClientInfo().getUser();
        if (user != null) {
            request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, user.getName(), user.getSecret()));
        }
        Response response = new Response(request);
        this.contextResourceFactory.getClient().handle(request, response);
        if (response.getStatus().isSuccess()) {
            this.contextResourceFactory.updateCache(response);
            return resourceHandler.handleResponse(response, this);
        }
        if (response.getStatus().isRedirection()) {
            Reference redirectedTo = response.getLocationRef();
            return this.invokeQuery(redirectedTo, queryRequest, resourceHandler, processingErrorHandler);
        }
        if (response.getStatus().equals((Object)Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY) && processingErrorHandler != null) {
            return processingErrorHandler.handleResponse(response, this);
        }
        return this.errorHandler.handleResponse(response, this);
    }

    HandlerCommand command(Link link, Object commandRequest, ResponseHandler handler, ResponseHandler processingErrorHandler) {
        if (handler == null) {
            handler = this.commandHandlers.get(link.rel().get());
        }
        if (processingErrorHandler == null) {
            processingErrorHandler = this.processingErrorHandlers.get(link.rel().get());
        }
        Method method = LinksUtil.withClass((String)"idempotent").satisfiedBy((Object)link) ? Method.PUT : Method.POST;
        Reference ref = new Reference(this.reference.toUri().toString() + (String)link.href().get());
        return this.invokeCommand(ref, method, commandRequest, handler, processingErrorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HandlerCommand invokeCommand(Reference ref, Method method, Object requestObject, ResponseHandler responseHandler, ResponseHandler processingErrorHandler) {
        Request request = new Request(method, ref);
        if (requestObject == null) {
            requestObject = new EmptyRepresentation();
        }
        this.contextResourceFactory.writeRequest(request, requestObject);
        this.contextResourceFactory.updateCommandRequest(request);
        User user = request.getClientInfo().getUser();
        if (user != null) {
            request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, user.getName(), user.getSecret()));
        }
        Response response = new Response(request);
        this.contextResourceFactory.getClient().handle(request, response);
        try {
            if (response.getStatus().isSuccess()) {
                this.contextResourceFactory.updateCache(response);
                if (responseHandler != null) {
                    HandlerCommand handlerCommand = responseHandler.handleResponse(response, this);
                    return handlerCommand;
                }
            } else {
                if (response.getStatus().equals((Object)Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY) && processingErrorHandler != null) {
                    HandlerCommand handlerCommand = processingErrorHandler.handleResponse(response, this);
                    return handlerCommand;
                }
                HandlerCommand handlerCommand = this.errorHandler.handleResponse(response, this);
                return handlerCommand;
            }
            HandlerCommand handlerCommand = null;
            return handlerCommand;
        }
        finally {
            try {
                response.getEntity().exhaust();
            }
            catch (Throwable e) {}
        }
    }

    public HandlerCommand delete(ResponseHandler responseHandler, ResponseHandler processingErrorHandler) throws ResourceException {
        if (responseHandler == null) {
            responseHandler = this.deleteHandler;
        }
        Request request = new Request(Method.DELETE, new Reference(this.reference.toUri()).toString());
        this.contextResourceFactory.updateCommandRequest(request);
        int tries = 3;
        while (true) {
            Response response = new Response(request);
            try {
                this.contextResourceFactory.getClient().handle(request, response);
                if (!response.getStatus().isSuccess()) {
                    HandlerCommand handlerCommand = this.errorHandler.handleResponse(response, this);
                    return handlerCommand;
                }
                this.contextResourceFactory.updateCache(response);
                HandlerCommand handlerCommand = responseHandler.handleResponse(response, this);
                return handlerCommand;
            }
            catch (ResourceException e) {
                if (e.getStatus().equals((Object)Status.CONNECTOR_ERROR_COMMUNICATION) || e.getStatus().equals((Object)Status.CONNECTOR_ERROR_CONNECTION)) {
                    if (tries == 0) {
                        throw e;
                    }
                    --tries;
                    continue;
                }
                throw e;
            }
            finally {
                try {
                    response.getEntity().exhaust();
                }
                catch (Throwable e) {}
                continue;
            }
            break;
        }
    }

    public synchronized ContextResourceClient newClient(Link link) {
        if (link == null) {
            throw new NullPointerException("No link specified");
        }
        return this.newClient((String)link.href().get());
    }

    public synchronized ContextResourceClient newClient(String relativePath) {
        if (relativePath.startsWith("http://")) {
            return this.contextResourceFactory.newClient(new Reference(relativePath));
        }
        Reference reference = this.reference.clone();
        if (relativePath.startsWith("/")) {
            reference.setPath(relativePath);
        } else {
            reference.setPath(reference.getPath() + relativePath);
            reference = reference.normalize();
        }
        return this.contextResourceFactory.newClient(reference);
    }

    private Object handlxeError(Response response) throws ResourceException {
        if (response.getStatus().equals((Object)Status.SERVER_ERROR_INTERNAL)) {
            if (MediaType.APPLICATION_JAVA_OBJECT.equals((Object)response.getEntity().getMediaType())) {
                try {
                    Serializable exception = new ObjectRepresentation(response.getEntity()).getObject();
                    throw new ResourceException((Throwable)exception);
                }
                catch (IOException e) {
                    throw new ResourceException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, response.getEntityAsText());
        }
        if (response.getEntity() != null) {
            String text = response.getEntityAsText();
            throw new ResourceException(response.getStatus().getCode(), response.getStatus().getName(), text, response.getRequest().getResourceRef().toUri().toString());
        }
        throw new ResourceException(response.getStatus().getCode(), response.getStatus().getName(), response.getStatus().getDescription(), response.getRequest().getResourceRef().toUri().toString());
    }

    public String toString() {
        return this.reference.toString();
    }
}

