/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client.requestwriter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.api.value.ValueSerializationException;
import org.qi4j.api.value.ValueSerializer;
import org.qi4j.library.rest.client.spi.RequestWriter;
import org.qi4j.spi.Qi4jSPI;
import org.restlet.Request;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.engine.io.WriterOutputStream;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class ValueCompositeRequestWriter
implements RequestWriter {
    @Structure
    private Qi4jSPI spi;
    @Service
    @Tagged(value={"json"})
    private ValueSerializer valueSerializer;

    @Override
    public boolean writeRequest(Object requestObject, Request request) throws ResourceException {
        if (requestObject instanceof ValueComposite) {
            final ValueComposite valueObject = (ValueComposite)requestObject;
            if (request.getMethod().equals((Object)Method.GET)) {
                AssociationStateHolder holder = this.spi.stateOf(valueObject);
                ValueDescriptor descriptor = this.spi.valueDescriptorFor((Object)valueObject);
                Reference ref = request.getResourceRef();
                ref.setQuery(null);
                try {
                    for (PropertyDescriptor propertyDescriptor : descriptor.state().properties()) {
                        Object value = holder.propertyFor(propertyDescriptor.accessor()).get();
                        String param = value == null ? null : this.valueSerializer.serialize(value);
                        ref.addQueryParameter(propertyDescriptor.qualifiedName().name(), param);
                    }
                }
                catch (ValueSerializationException e) {
                    throw new ResourceException((Throwable)e);
                }
            } else {
                request.setEntity((Representation)new WriterRepresentation(MediaType.APPLICATION_JSON){

                    public void write(Writer writer) throws IOException {
                        this.setCharacterSet(CharacterSet.UTF_8);
                        ValueCompositeRequestWriter.this.valueSerializer.serialize((Object)valueObject, (OutputStream)new WriterOutputStream(writer));
                    }
                });
            }
            return true;
        }
        return false;
    }
}

