/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.reindexer.internal;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.index.reindexer.Reindexer;
import org.qi4j.index.reindexer.ReindexerConfiguration;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.StateChangeListener;
import org.qi4j.spi.module.ModuleSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexerMixin
implements Reindexer {
    private static QualifiedName identityQN;
    @This
    private Configuration<ReindexerConfiguration> configuration;
    @Service
    private EntityStore store;
    @Service
    private Iterable<ServiceReference<StateChangeListener>> listeners;
    @Structure
    private ModuleSpi module;
    private Logger logger = LoggerFactory.getLogger(Reindexer.class);

    @Override
    public void reindex() {
        this.configuration.refresh();
        ReindexerConfiguration conf = (ReindexerConfiguration)this.configuration.get();
        Integer loadValue = (Integer)conf.loadValue().get();
        if (loadValue == null) {
            loadValue = 50;
        }
        new ReindexerOutput(loadValue).reindex(this.store);
    }

    static {
        try {
            identityQN = QualifiedName.fromAccessor((AccessibleObject)Identity.class.getMethod("identity", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Zest Core Runtime codebase is corrupted. Contact Zest team: ReindexerMixin");
        }
    }

    private class ReindexerOutput
    implements Output<EntityState, RuntimeException>,
    Receiver<EntityState, RuntimeException> {
        private int count;
        private int loadValue;
        private ArrayList<EntityState> states;

        public ReindexerOutput(Integer loadValue) {
            this.loadValue = loadValue;
            this.states = new ArrayList();
        }

        public void reindex(EntityStore store) {
            store.entityStates(ReindexerMixin.this.module).transferTo((Output)this);
            this.reindexState();
        }

        public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends EntityState, SenderThrowableType> sender) throws RuntimeException, SenderThrowableType {
            sender.sendTo((Receiver)this);
            this.reindexState();
        }

        public void receive(EntityState item) throws RuntimeException {
            ++this.count;
            item.setPropertyValue(identityQN, (Object)item.identity().identity());
            this.states.add(item);
            if (this.states.size() >= this.loadValue) {
                this.reindexState();
            }
        }

        public void reindexState() {
            for (ServiceReference listener : ReindexerMixin.this.listeners) {
                ((StateChangeListener)listener.get()).notifyChanges(this.states);
            }
            this.states.clear();
            ReindexerMixin.this.logger.debug("Reindexed " + this.count + " entities");
        }
    }
}

