/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.qi4j.bootstrap.Assembler;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;

public final class AssemblerCollection
implements Assembler {
    Collection<Assembler> assemblers;

    public AssemblerCollection(Assembler ... assemblers) {
        this.assemblers = Arrays.asList(assemblers);
    }

    @SafeVarargs
    public AssemblerCollection(Class<? extends Assembler> ... assemblyClasses) throws AssemblyException {
        this.assemblers = new ArrayList<Assembler>();
        for (Class<? extends Assembler> assemblyClass : assemblyClasses) {
            try {
                Assembler assembler = assemblyClass.newInstance();
                this.assemblers.add(assembler);
            }
            catch (Exception e) {
                throw new AssemblyException("Could not instantiate assembly with class " + assemblyClass.getName(), e);
            }
        }
    }

    public AssemblerCollection(Collection<Assembler> assemblers) {
        this.assemblers = assemblers;
    }

    @Override
    public void assemble(ModuleAssembly module) throws AssemblyException {
        for (Assembler assembler : this.assemblers) {
            assembler.assemble(module);
        }
    }
}

