/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.bootstrap;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;

public class ClassScanner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<Class<?>> findClasses(final Class<?> seedClass) {
        File file;
        CodeSource codeSource = seedClass.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return Iterables.empty();
        }
        URL location = codeSource.getLocation();
        if (!location.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Can only enumerate classes from file system locations. URL is:" + location);
        }
        try {
            file = new File(location.toURI().getPath());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The file location of codebase is invalid. Can not convert to URI. URL is:" + location);
        }
        if (file.getName().endsWith(".jar")) {
            List list;
            final String packageName = seedClass.getPackage().getName().replace('.', '/');
            JarFile jarFile = new JarFile(file);
            Iterable entries = Iterables.iterable(jarFile.entries());
            try {
                list = Iterables.toList((Iterable)Iterables.filter((Specification)new ValidClass(), (Iterable)Iterables.map((Function)new Function<JarEntry, Class<?>>(){

                    public Class map(JarEntry jarEntry) {
                        String name = jarEntry.getName();
                        name = name.substring(0, name.length() - 6);
                        name = name.replace('/', '.');
                        try {
                            return seedClass.getClassLoader().loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            return null;
                        }
                    }
                }, (Iterable)Iterables.filter((Specification)new Specification<JarEntry>(){

                    public boolean satisfiedBy(JarEntry jarEntry) {
                        return jarEntry.getName().startsWith(packageName) && jarEntry.getName().endsWith(".class");
                    }
                }, (Iterable)entries))));
            }
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not open jar file " + file, e);
                }
            }
            jarFile.close();
            return list;
        }
        File path = new File(file, seedClass.getPackage().getName().replace('.', File.separatorChar));
        Iterable<File> files = ClassScanner.findFiles(path, new Specification<File>(){

            public boolean satisfiedBy(File file) {
                return file.getName().endsWith(".class");
            }
        });
        return Iterables.filter((Specification)new ValidClass(), (Iterable)Iterables.map((Function)new Function<File, Class<?>>(){

            public Class<?> map(File f) {
                String fileName = f.getAbsolutePath().substring(file.toString().length() + 1);
                fileName = fileName.replace(File.separatorChar, '.').substring(0, fileName.length() - 6);
                try {
                    return seedClass.getClassLoader().loadClass(fileName);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }, files));
    }

    public static Specification<Class<?>> matches(String regex) {
        final Pattern pattern = Pattern.compile(regex);
        return new Specification<Class<?>>(){

            public boolean satisfiedBy(Class<?> aClass) {
                return pattern.matcher(aClass.getName()).matches();
            }
        };
    }

    private static Iterable<File> findFiles(File directory, final Specification<File> filter) {
        return Iterables.flatten((Iterable[])new Iterable[]{Iterables.filter(filter, (Iterable)Iterables.iterable((Object[])directory.listFiles())), Iterables.flattenIterables((Iterable)Iterables.map((Function)new Function<File, Iterable<File>>(){

            public Iterable<File> map(File file) {
                return ClassScanner.findFiles(file, (Specification<File>)filter);
            }
        }, (Iterable)Iterables.filter((Specification)new Specification<File>(){

            public boolean satisfiedBy(File file) {
                return file.isDirectory();
            }
        }, (Iterable)Iterables.iterable((Object[])directory.listFiles()))))});
    }

    private static class ValidClass
    implements Specification<Class<?>> {
        private ValidClass() {
        }

        public boolean satisfiedBy(Class<?> item) {
            return (item.isInterface() || !Modifier.isAbstract(item.getModifiers())) && !item.isEnum() && !item.isAnonymousClass();
        }
    }
}

