/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.bootstrap.layered;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.bootstrap.layered.LayerAssembler;
import org.qi4j.bootstrap.layered.LayeredApplicationAssembler;
import org.qi4j.bootstrap.layered.ModuleAssembler;

public abstract class LayeredLayerAssembler
implements LayerAssembler {
    private HashMap<Class<? extends ModuleAssembler>, ModuleAssembler> assemblers = new HashMap();

    protected ModuleAssembly createModule(LayerAssembly layer, Class<? extends ModuleAssembler> modulerAssemblerClass) {
        try {
            ModuleAssembler moduleAssembler = this.instantiateAssembler(layer, modulerAssemblerClass);
            String moduleName = this.createModuleName(modulerAssemblerClass);
            LayeredApplicationAssembler.setNameIfPresent(modulerAssemblerClass, moduleName);
            ModuleAssembly module = layer.module(moduleName);
            this.assemblers.put(modulerAssemblerClass, moduleAssembler);
            ModuleAssembly assembly = moduleAssembler.assemble(layer, module);
            if (assembly == null) {
                return module;
            }
            return assembly;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate module with " + modulerAssemblerClass.getSimpleName(), e);
        }
    }

    protected String createModuleName(Class<? extends ModuleAssembler> modulerAssemblerClass) {
        String moduleName = modulerAssemblerClass.getSimpleName();
        if (moduleName.endsWith("Module")) {
            moduleName = moduleName.substring(0, moduleName.length() - 6) + " Module";
        }
        return moduleName;
    }

    private ModuleAssembler instantiateAssembler(LayerAssembly layer, Class<? extends ModuleAssembler> modulerAssemblerClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ModuleAssembler moduleAssembler;
        try {
            Constructor<? extends ModuleAssembler> assemblyConstructor = modulerAssemblerClass.getConstructor(ModuleAssembly.class);
            moduleAssembler = assemblyConstructor.newInstance(layer);
        }
        catch (NoSuchMethodException e) {
            moduleAssembler = modulerAssemblerClass.newInstance();
        }
        return moduleAssembler;
    }

    protected <T extends ModuleAssembler> T assemblerOf(Class<T> moduleAssemblerType) {
        return (T)this.assemblers.get(moduleAssemblerType);
    }
}

