/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.application.factory;

import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONWriter;
import org.qi4j.api.concern.Concerns;
import org.qi4j.api.entity.IdentityGenerator;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Application;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.library.eventsourcing.application.api.ApplicationEvent;
import org.qi4j.library.eventsourcing.application.factory.ApplicationEventFactory;
import org.qi4j.library.eventsourcing.application.factory.TransactionNotificationConcern;
import org.qi4j.library.eventsourcing.domain.spi.CurrentUser;

@Concerns(value={TransactionNotificationConcern.class})
@Mixins(value={Mixin.class})
public interface ApplicationEventFactoryService
extends ApplicationEventFactory,
ServiceComposite {

    public static class Mixin
    implements ApplicationEventFactory {
        @Structure
        UnitOfWorkFactory uowf;
        @Structure
        ValueBuilderFactory vbf;
        @Service
        IdentityGenerator idGenerator;
        @Service
        CurrentUser currentUser;
        String version;

        public void init(@Structure Application application) {
            this.version = application.version();
        }

        @Override
        public ApplicationEvent createEvent(String name, Object[] args) {
            ValueBuilder builder = this.vbf.newValueBuilder(ApplicationEvent.class);
            ApplicationEvent prototype = (ApplicationEvent)builder.prototype();
            prototype.name().set((Object)name);
            prototype.on().set((Object)new Date());
            prototype.identity().set((Object)this.idGenerator.generate(ApplicationEvent.class));
            UnitOfWork uow = this.uowf.currentUnitOfWork();
            prototype.usecase().set((Object)uow.usecase().name());
            prototype.version().set((Object)this.version);
            JSONStringer json = new JSONStringer();
            try {
                JSONWriter params = json.object();
                for (int i = 1; i < args.length; ++i) {
                    params.key("param" + i);
                    if (args[i] == null) {
                        params.value(JSONObject.NULL);
                        continue;
                    }
                    params.value(args[i]);
                }
                json.endObject();
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Could not create event", e);
            }
            prototype.parameters().set((Object)json.toString());
            ApplicationEvent event = (ApplicationEvent)builder.newInstance();
            return event;
        }
    }
}

