/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.application.factory;

import java.io.IOException;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCallback;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.library.eventsourcing.application.api.ApplicationEvent;
import org.qi4j.library.eventsourcing.application.factory.ApplicationEventFactory;
import org.qi4j.library.eventsourcing.application.factory.UnitOfWorkApplicationEvents;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventStore;
import org.qi4j.library.eventsourcing.domain.factory.DomainEventFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionNotificationConcern
extends ConcernOf<ApplicationEventFactory>
implements ApplicationEventFactory {
    @Service
    ApplicationEventStore eventStore;
    @Structure
    UnitOfWorkFactory uowf;
    Logger logger = LoggerFactory.getLogger(DomainEventFactory.class);

    @Override
    public ApplicationEvent createEvent(String name, Object[] args) {
        final UnitOfWork unitOfWork = this.uowf.currentUnitOfWork();
        ApplicationEvent event = ((ApplicationEventFactory)this.next).createEvent(name, args);
        UnitOfWorkApplicationEvents events = (UnitOfWorkApplicationEvents)unitOfWork.metaInfo(UnitOfWorkApplicationEvents.class);
        if (events == null) {
            events = new UnitOfWorkApplicationEvents();
            unitOfWork.setMetaInfo((Object)events);
            unitOfWork.addUnitOfWorkCallback(new UnitOfWorkCallback(){

                public void beforeCompletion() throws UnitOfWorkCompletionException {
                }

                public void afterCompletion(UnitOfWorkCallback.UnitOfWorkStatus status) {
                    if (status.equals((Object)UnitOfWorkCallback.UnitOfWorkStatus.COMPLETED)) {
                        UnitOfWorkApplicationEvents events = (UnitOfWorkApplicationEvents)unitOfWork.metaInfo(UnitOfWorkApplicationEvents.class);
                        try {
                            TransactionNotificationConcern.this.eventStore.storeEvents(events.getEvents());
                        }
                        catch (IOException e) {
                            TransactionNotificationConcern.this.logger.error("Could not store events", (Throwable)e);
                        }
                    }
                }
            });
        }
        events.add(event);
        return event;
    }
}

