/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.application.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.functional.Iterables;
import org.qi4j.io.Input;
import org.qi4j.io.Inputs;
import org.qi4j.io.Output;
import org.qi4j.library.eventsourcing.application.api.ApplicationEvent;
import org.qi4j.library.eventsourcing.application.api.TransactionApplicationEvents;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventStore;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventStoreActivation;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplicationEventStoreMixin
implements ApplicationEventStore,
ApplicationEventStream,
ApplicationEventStoreActivation {
    @This
    protected Identity identity;
    protected Logger logger;
    protected ValueType domainEventType;
    protected ValueType transactionEventsType;
    protected Lock lock = new ReentrantLock();
    @Structure
    protected Module module;
    @Structure
    private ValueBuilderFactory vbf;
    private ExecutorService transactionNotifier;
    private final List<Output<TransactionApplicationEvents, ? extends Throwable>> listeners = Collections.synchronizedList(new ArrayList());
    private long lastTimestamp = 0L;

    @Override
    public void activateApplicationEventStore() throws Exception {
        this.logger = LoggerFactory.getLogger((String)((String)this.identity.identity().get()));
        this.domainEventType = this.module.valueDescriptor(ApplicationEvent.class.getName()).valueType();
        this.transactionEventsType = this.module.valueDescriptor(TransactionApplicationEvents.class.getName()).valueType();
        this.transactionNotifier = Executors.newSingleThreadExecutor();
    }

    @Override
    public void passivateApplicationEventStore() throws Exception {
        this.transactionNotifier.shutdown();
        this.transactionNotifier.awaitTermination(10000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionApplicationEvents storeEvents(Iterable<ApplicationEvent> events) throws IOException {
        ValueBuilder builder = this.vbf.newValueBuilder(TransactionApplicationEvents.class);
        Iterables.addAll((Collection)((Collection)((TransactionApplicationEvents)builder.prototype()).events().get()), events);
        ((TransactionApplicationEvents)builder.prototype()).timestamp().set((Object)this.getCurrentTimestamp());
        final TransactionApplicationEvents transactionDomain = (TransactionApplicationEvents)builder.newInstance();
        this.lock();
        try {
            this.storeEvents(transactionDomain);
        }
        finally {
            this.lock.unlock();
        }
        this.transactionNotifier.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = AbstractApplicationEventStoreMixin.this.listeners;
                synchronized (list) {
                    Input input = Inputs.iterable(Collections.singleton(transactionDomain));
                    for (Output listener : AbstractApplicationEventStoreMixin.this.listeners) {
                        try {
                            input.transferTo(listener);
                        }
                        catch (Throwable e) {
                            AbstractApplicationEventStoreMixin.this.logger.warn("Could not notify event listener", e);
                        }
                    }
                }
            }
        });
        return transactionDomain;
    }

    @Override
    public void registerListener(Output<TransactionApplicationEvents, ? extends Throwable> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(Output<TransactionApplicationEvents, ? extends Throwable> listener) {
        this.listeners.remove(listener);
    }

    protected abstract void rollback() throws IOException;

    protected abstract void commit() throws IOException;

    protected abstract void storeEvents(TransactionApplicationEvents var1) throws IOException;

    protected void lock() {
        while (true) {
            try {
                this.lock.tryLock(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private synchronized long getCurrentTimestamp() {
        long timestamp = System.currentTimeMillis();
        if (timestamp <= this.lastTimestamp) {
            timestamp = this.lastTimestamp + 1L;
        }
        this.lastTimestamp = timestamp;
        return timestamp;
    }
}

