/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.application.source.helper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import org.qi4j.api.util.Methods;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.eventsourcing.application.api.ApplicationEvent;
import org.qi4j.library.eventsourcing.application.api.TransactionApplicationEvents;
import org.qi4j.library.eventsourcing.application.replay.ApplicationEventPlayer;
import org.qi4j.library.eventsourcing.application.replay.ApplicationEventReplayException;
import org.qi4j.library.eventsourcing.application.source.helper.ApplicationEventParameters;

public class ApplicationEvents {
    public static Iterable<ApplicationEvent> events(Iterable<TransactionApplicationEvents> transactions) {
        ArrayList<Object> events = new ArrayList<Object>();
        for (TransactionApplicationEvents transactionDomain : transactions) {
            events.add(transactionDomain.events().get());
        }
        Iterable[] iterables = new Iterable[events.size()];
        return Iterables.flatten((Iterable[])events.toArray(iterables));
    }

    public static Iterable<ApplicationEvent> events(TransactionApplicationEvents ... transactionDomains) {
        ArrayList<Object> events = new ArrayList<Object>();
        for (TransactionApplicationEvents transactionDomain : transactionDomains) {
            events.add(transactionDomain.events().get());
        }
        Iterable[] iterables = new Iterable[events.size()];
        return Iterables.flatten((Iterable[])events.toArray(iterables));
    }

    public static boolean matches(Specification<ApplicationEvent> specification, Iterable<TransactionApplicationEvents> transactions) {
        return Iterables.filter(specification, ApplicationEvents.events(transactions)).iterator().hasNext();
    }

    public static Specification<ApplicationEvent> withNames(final Iterable<String> names) {
        return new Specification<ApplicationEvent>(){

            public boolean satisfiedBy(ApplicationEvent event) {
                for (String name : names) {
                    if (!((String)event.name().get()).equals(name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<ApplicationEvent> withNames(final String ... names) {
        return new Specification<ApplicationEvent>(){

            public boolean satisfiedBy(ApplicationEvent event) {
                for (String name : names) {
                    if (!((String)event.name().get()).equals(name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<ApplicationEvent> withNames(Class eventClass) {
        return ApplicationEvents.withNames(Iterables.map((Function)new Function<Method, String>(){

            public String map(Method method) {
                return method.getName();
            }
        }, (Iterable)Iterables.toList((Iterable)((Iterable)Methods.METHODS_OF.map((Object)eventClass)))));
    }

    public static Specification<ApplicationEvent> afterDate(final Date afterDate) {
        return new Specification<ApplicationEvent>(){

            public boolean satisfiedBy(ApplicationEvent event) {
                return ((Date)event.on().get()).after(afterDate);
            }
        };
    }

    public static Specification<ApplicationEvent> beforeDate(final Date beforeDate) {
        return new Specification<ApplicationEvent>(){

            public boolean satisfiedBy(ApplicationEvent event) {
                return ((Date)event.on().get()).before(beforeDate);
            }
        };
    }

    public static Specification<ApplicationEvent> withUsecases(final String ... names) {
        return new Specification<ApplicationEvent>(){

            public boolean satisfiedBy(ApplicationEvent event) {
                for (String name : names) {
                    if (!((String)event.usecase().get()).equals(name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<ApplicationEvent> paramIs(final String name, final String value) {
        return new Specification<ApplicationEvent>(){

            public boolean satisfiedBy(ApplicationEvent event) {
                return ApplicationEventParameters.getParameter(event, name).equals(value);
            }
        };
    }

    public static Output<TransactionApplicationEvents, ApplicationEventReplayException> playEvents(final ApplicationEventPlayer player, final Object eventHandler) {
        final Specification<ApplicationEvent> specification = ApplicationEvents.withNames(eventHandler.getClass());
        return new Output<TransactionApplicationEvents, ApplicationEventReplayException>(){

            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends TransactionApplicationEvents, SenderThrowableType> sender) throws ApplicationEventReplayException, SenderThrowableType {
                sender.sendTo((Receiver)new Receiver<TransactionApplicationEvents, ApplicationEventReplayException>(){

                    public void receive(TransactionApplicationEvents item) throws ApplicationEventReplayException {
                        for (ApplicationEvent applicationEvent : ApplicationEvents.events(item)) {
                            if (!specification.satisfiedBy((Object)applicationEvent)) continue;
                            player.playEvent(applicationEvent, eventHandler);
                        }
                    }
                });
            }
        };
    }
}

