/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.application.source.memory;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.eventsourcing.application.api.TransactionApplicationEvents;
import org.qi4j.library.eventsourcing.application.source.AbstractApplicationEventStoreMixin;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventSource;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventStore;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventStoreActivation;
import org.qi4j.library.eventsourcing.application.source.ApplicationEventStream;

@Mixins(value={MemoryStoreMixin.class})
@Activators(value={ApplicationEventStoreActivation.Activator.class})
public interface MemoryApplicationEventStoreService
extends ApplicationEventSource,
ApplicationEventStore,
ApplicationEventStream,
ApplicationEventStoreActivation,
ServiceComposite {

    public static abstract class MemoryStoreMixin
    extends AbstractApplicationEventStoreMixin
    implements ApplicationEventSource,
    ApplicationEventStoreActivation {
        private LinkedList<TransactionApplicationEvents> store = new LinkedList();

        @Override
        public Input<TransactionApplicationEvents, IOException> transactionsAfter(final long afterTimestamp, final long maxTransactions) {
            return new Input<TransactionApplicationEvents, IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super TransactionApplicationEvents, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                    MemoryStoreMixin.this.lock.lock();
                    try {
                        output.receiveFrom((Sender)new Sender<TransactionApplicationEvents, IOException>(){

                            public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super TransactionApplicationEvents, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                                Iterator iterator = MemoryStoreMixin.this.store.iterator();
                                long count = 0L;
                                while (iterator.hasNext() && count < maxTransactions) {
                                    TransactionApplicationEvents next = (TransactionApplicationEvents)iterator.next();
                                    if ((Long)next.timestamp().get() <= afterTimestamp) continue;
                                    receiver.receive((Object)next);
                                    ++count;
                                }
                            }
                        });
                    }
                    finally {
                        MemoryStoreMixin.this.lock.unlock();
                    }
                }
            };
        }

        @Override
        public Input<TransactionApplicationEvents, IOException> transactionsBefore(final long beforeTimestamp, final long maxTransactions) {
            return new Input<TransactionApplicationEvents, IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super TransactionApplicationEvents, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                    MemoryStoreMixin.this.lock.lock();
                    try {
                        output.receiveFrom((Sender)new Sender<TransactionApplicationEvents, IOException>(){

                            public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super TransactionApplicationEvents, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                                Iterator iterator = MemoryStoreMixin.this.store.descendingIterator();
                                long count = 0L;
                                while (iterator.hasNext() && count < maxTransactions) {
                                    TransactionApplicationEvents next = (TransactionApplicationEvents)iterator.next();
                                    if ((Long)next.timestamp().get() >= beforeTimestamp) continue;
                                    receiver.receive((Object)next);
                                    ++count;
                                }
                            }
                        });
                    }
                    finally {
                        MemoryStoreMixin.this.lock.unlock();
                    }
                }
            };
        }

        @Override
        protected void storeEvents(TransactionApplicationEvents transactionDomain) throws IOException {
            this.store.add(transactionDomain);
        }
    }
}

