/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.domain.replay;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.library.eventsourcing.domain.api.DomainEventValue;
import org.qi4j.library.eventsourcing.domain.api.UnitOfWorkDomainEventsValue;
import org.qi4j.library.eventsourcing.domain.replay.DomainEventPlayer;
import org.qi4j.library.eventsourcing.domain.replay.EventReplayException;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.entity.EntityState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface DomainEventPlayerService
extends DomainEventPlayer,
ServiceComposite {

    public static class Mixin
    implements DomainEventPlayer {
        final Logger logger = LoggerFactory.getLogger(DomainEventPlayer.class);
        @Structure
        UnitOfWorkFactory uowf;
        @Structure
        Module module;
        @Structure
        Qi4jSPI spi;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");

        @Override
        public void playTransaction(UnitOfWorkDomainEventsValue unitOfWorkDomainValue) throws EventReplayException {
            UnitOfWork uow = this.uowf.newUnitOfWork(UsecaseBuilder.newUsecase((String)"Event replay"));
            DomainEventValue currentEventValue = null;
            try {
                Iterator i$ = ((List)unitOfWorkDomainValue.events().get()).iterator();
                while (i$.hasNext()) {
                    DomainEventValue domainEventValue;
                    currentEventValue = domainEventValue = (DomainEventValue)i$.next();
                    Class<?> entityType = this.module.classLoader().loadClass((String)domainEventValue.entityType().get());
                    String id = (String)domainEventValue.entityId().get();
                    Object entity = null;
                    try {
                        entity = uow.get(entityType, id);
                    }
                    catch (NoSuchEntityException e) {
                        entity = uow.newEntity(entityType, id);
                    }
                    EntityState state = this.spi.entityStateOf((EntityComposite)entity);
                    if (state.lastModified() > (Long)unitOfWorkDomainValue.timestamp().get()) break;
                    this.playEvent(domainEventValue, entity);
                }
                uow.complete();
            }
            catch (Exception e) {
                uow.discard();
                if (e instanceof EventReplayException) {
                    throw (EventReplayException)e;
                }
                throw new EventReplayException(currentEventValue, (Throwable)e);
            }
        }

        @Override
        public void playEvent(DomainEventValue domainEventValue, Object object) throws EventReplayException {
            UnitOfWork uow = this.uowf.currentUnitOfWork();
            Class<?> entityType = object.getClass();
            Method eventMethod = this.getEventMethod(entityType, (String)domainEventValue.name().get());
            if (eventMethod == null) {
                this.logger.warn("Could not find event method " + (String)domainEventValue.name().get() + " in entity of type " + entityType.getName());
                return;
            }
            try {
                String jsonParameters = (String)domainEventValue.parameters().get();
                JSONObject parameters = (JSONObject)new JSONTokener(jsonParameters).nextValue();
                Object[] args = new Object[eventMethod.getParameterTypes().length];
                for (int i = 1; i < eventMethod.getParameterTypes().length; ++i) {
                    Class<?> parameterType = eventMethod.getParameterTypes()[i];
                    String paramName = "param" + i;
                    Object value = parameters.get(paramName);
                    args[i] = this.getParameterArgument(parameterType, value, uow);
                }
                args[0] = domainEventValue;
                this.logger.debug("Replay:" + domainEventValue + " on:" + object);
                eventMethod.invoke(object, args);
            }
            catch (Exception e) {
                throw new EventReplayException(domainEventValue, (Throwable)e);
            }
        }

        private Object getParameterArgument(Class<?> parameterType, Object value, UnitOfWork uow) throws ParseException {
            if (value.equals(JSONObject.NULL)) {
                return null;
            }
            if (parameterType.equals(String.class)) {
                return (String)value;
            }
            if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
                return (Boolean)value;
            }
            if (parameterType.equals(Long.class) || parameterType.equals(Long.TYPE)) {
                return ((Number)value).longValue();
            }
            if (parameterType.equals(Integer.class) || parameterType.equals(Integer.TYPE)) {
                return ((Number)value).intValue();
            }
            if (parameterType.equals(Date.class)) {
                return this.dateFormat.parse((String)value);
            }
            if (ValueComposite.class.isAssignableFrom(parameterType)) {
                return this.module.newValueFromSerializedState(parameterType, (String)value);
            }
            if (parameterType.isInterface()) {
                return uow.get(parameterType, (String)value);
            }
            if (parameterType.isEnum()) {
                return Enum.valueOf(parameterType, value.toString());
            }
            throw new IllegalArgumentException("Unknown parameter type:" + parameterType.getName());
        }

        private Method getEventMethod(Class<?> aClass, String eventName) {
            for (Method method : aClass.getMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals(eventName) || (parameterTypes = method.getParameterTypes()).length <= 0 || !parameterTypes[0].equals(DomainEventValue.class)) continue;
                return method;
            }
            return null;
        }
    }
}

