/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.eventsourcing.domain.source.helper;

import java.lang.reflect.Method;
import java.util.Date;
import org.qi4j.api.util.Methods;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.library.eventsourcing.domain.api.DomainEventValue;
import org.qi4j.library.eventsourcing.domain.api.UnitOfWorkDomainEventsValue;
import org.qi4j.library.eventsourcing.domain.source.helper.EventParameters;

public class Events {
    public static Iterable<DomainEventValue> events(Iterable<UnitOfWorkDomainEventsValue> transactions) {
        return Iterables.flattenIterables((Iterable)Iterables.map((Function)new Function<UnitOfWorkDomainEventsValue, Iterable<DomainEventValue>>(){

            public Iterable<DomainEventValue> map(UnitOfWorkDomainEventsValue unitOfWorkDomainEventsValue) {
                return (Iterable)unitOfWorkDomainEventsValue.events().get();
            }
        }, transactions));
    }

    public static Iterable<DomainEventValue> events(UnitOfWorkDomainEventsValue ... unitOfWorkDomainValues) {
        return Events.events(Iterables.iterable((Object[])unitOfWorkDomainValues));
    }

    public static Specification<UnitOfWorkDomainEventsValue> afterDate(final Date afterDate) {
        return new Specification<UnitOfWorkDomainEventsValue>(){

            public boolean satisfiedBy(UnitOfWorkDomainEventsValue eventValue) {
                return (Long)eventValue.timestamp().get() > afterDate.getTime();
            }
        };
    }

    public static Specification<UnitOfWorkDomainEventsValue> beforeDate(final Date afterDate) {
        return new Specification<UnitOfWorkDomainEventsValue>(){

            public boolean satisfiedBy(UnitOfWorkDomainEventsValue eventValue) {
                return (Long)eventValue.timestamp().get() < afterDate.getTime();
            }
        };
    }

    public static Specification<UnitOfWorkDomainEventsValue> withUsecases(final String ... names) {
        return new Specification<UnitOfWorkDomainEventsValue>(){

            public boolean satisfiedBy(UnitOfWorkDomainEventsValue eventValue) {
                for (String name : names) {
                    if (!((String)eventValue.usecase().get()).equals(name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<UnitOfWorkDomainEventsValue> byUser(final String ... by) {
        return new Specification<UnitOfWorkDomainEventsValue>(){

            public boolean satisfiedBy(UnitOfWorkDomainEventsValue eventValue) {
                for (String user : by) {
                    if (!((String)eventValue.user().get()).equals(user)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<DomainEventValue> withNames(final Iterable<String> names) {
        return new Specification<DomainEventValue>(){

            public boolean satisfiedBy(DomainEventValue eventValue) {
                for (String name : names) {
                    if (!((String)eventValue.name().get()).equals(name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<DomainEventValue> withNames(final String ... names) {
        return new Specification<DomainEventValue>(){

            public boolean satisfiedBy(DomainEventValue eventValue) {
                for (String name : names) {
                    if (!((String)eventValue.name().get()).equals(name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<DomainEventValue> withNames(Class eventClass) {
        return Events.withNames(Iterables.map((Function)new Function<Method, String>(){

            public String map(Method method) {
                return method.getName();
            }
        }, (Iterable)Iterables.toList((Iterable)((Iterable)Methods.METHODS_OF.map((Object)eventClass)))));
    }

    public static Specification<DomainEventValue> onEntities(final String ... entities) {
        return new Specification<DomainEventValue>(){

            public boolean satisfiedBy(DomainEventValue eventValue) {
                for (String entity : entities) {
                    if (!((String)eventValue.entityId().get()).equals(entity)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<DomainEventValue> onEntityTypes(final String ... entityTypes) {
        return new Specification<DomainEventValue>(){

            public boolean satisfiedBy(DomainEventValue eventValue) {
                for (String entityType : entityTypes) {
                    if (!((String)eventValue.entityType().get()).equals(entityType)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Specification<DomainEventValue> paramIs(final String name, final String value) {
        return new Specification<DomainEventValue>(){

            public boolean satisfiedBy(DomainEventValue eventValue) {
                return EventParameters.getParameter(eventValue, name).equals(value);
            }
        };
    }
}

