/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.osgi;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.service.qualifier.HasMetaInfo;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;

@Mixins(value={OSGiServiceExporterMixin.class})
@Activators(value={Activator.class})
public interface OSGiServiceExporter
extends ServiceComposite {
    public void registerServices() throws Exception;

    public void unregisterServices() throws Exception;

    public static abstract class OSGiServiceExporterMixin
    implements OSGiServiceExporter {
        @Service
        @HasMetaInfo(value={BundleContext.class})
        private Iterable<ServiceReference<ServiceComposite>> services;
        private ArrayList<ServiceRegistration> registrations = new ArrayList();

        @Override
        public void registerServices() throws Exception {
            for (ServiceReference<ServiceComposite> ref : this.services) {
                Class<BundleContext> type = BundleContext.class;
                BundleContext context = (BundleContext)ref.metaInfo(type);
                ServiceComposite service = (ServiceComposite)ref.get();
                Iterable interfaces = Iterables.map((Function)Classes.RAW_CLASS, (Iterable)Classes.interfacesOf(service.getClass()));
                String[] interfaceNames = new String[(int)Iterables.count((Iterable)interfaces)];
                Properties properties = (Properties)ref.metaInfo(Properties.class);
                if (properties == null) {
                    properties = new Properties();
                }
                properties.put("org.qi4j.api.service.active", (Object)ref.isActive());
                properties.put("org.qi4j.api.service.available", (Object)ref.isAvailable());
                properties.put("org.qi4j.api.service.identity", ref.identity());
                int i = 0;
                for (Class cls : interfaces) {
                    interfaceNames[i++] = cls.getName();
                }
                this.registrations.add(context.registerService(interfaceNames, (Object)service, (Dictionary)properties));
            }
        }

        @Override
        public void unregisterServices() throws Exception {
            for (ServiceRegistration reg : this.registrations) {
                reg.unregister();
            }
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<OSGiServiceExporter>> {
        public void afterActivation(ServiceReference<OSGiServiceExporter> activated) throws Exception {
            ((OSGiServiceExporter)activated.get()).registerServices();
        }

        public void beforePassivation(ServiceReference<OSGiServiceExporter> passivating) throws Exception {
            ((OSGiServiceExporter)passivating.get()).unregisterServices();
        }
    }
}

