/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entity;

import java.io.Serializable;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Iterables;

public final class QualifiedIdentity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final QualifiedIdentity NULL = new QualifiedIdentity("null", "none");
    private String identity;
    private String compositeType;

    public static QualifiedIdentity parseURI(String uri) {
        String str = uri.substring("urn:qi4j:entity:".length());
        int idx = str.indexOf("/");
        String type = str.substring(0, idx).replace("-", "$");
        String identity = str.substring(idx + 1);
        return new QualifiedIdentity(identity, type);
    }

    public static QualifiedIdentity parseQualifiedIdentity(String id) {
        return new QualifiedIdentity(id);
    }

    public static QualifiedIdentity qualifiedIdentityOf(Object o) {
        return new QualifiedIdentity((EntityComposite)o);
    }

    public QualifiedIdentity(EntityComposite entityComposite) {
        this((String)entityComposite.identity().get(), ((Class)Iterables.first((Iterable)((CompositeDescriptor)Qi4j.FUNCTION_DESCRIPTOR_FOR.map((Object)entityComposite)).types())).getName());
    }

    public QualifiedIdentity(String identity, Class<?> clazz) {
        this.identity = identity;
        this.compositeType = clazz.getName();
    }

    public QualifiedIdentity(String identity, String clazz) {
        this.identity = identity;
        this.compositeType = clazz;
    }

    protected QualifiedIdentity(String qualifiedIdentity) {
        int separatorIndex = qualifiedIdentity.indexOf(":");
        if (separatorIndex == -1) {
            throw new IllegalArgumentException("Supplied string is not a qualified identity: " + qualifiedIdentity);
        }
        this.compositeType = qualifiedIdentity.substring(0, separatorIndex);
        this.identity = qualifiedIdentity.substring(separatorIndex + 1);
    }

    public final String identity() {
        return this.identity;
    }

    public final String type() {
        return this.compositeType;
    }

    public final String toURI() {
        return "urn:qi4j:entity:" + Classes.normalizeClassToURI((String)this.compositeType) + "/" + this.identity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedIdentity that = (QualifiedIdentity)o;
        return this.compositeType.equals(that.compositeType) && this.identity.equals(that.identity);
    }

    public int hashCode() {
        int result = this.identity.hashCode();
        result = 31 * result + this.compositeType.hashCode();
        return result;
    }

    public String toString() {
        return this.compositeType + ":" + this.identity;
    }
}

