/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.qi4j.api.Qi4j;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStateVersions;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateCommitter;
import org.qi4j.spi.module.ModuleSpi;

public abstract class ConcurrentModificationCheckConcern
extends ConcernOf<EntityStore>
implements EntityStore {
    @This
    private EntityStateVersions versions;
    @Structure
    private Qi4j api;

    @Override
    public EntityStoreUnitOfWork newUnitOfWork(Usecase usecase, ModuleSpi module, long currentTime) {
        EntityStoreUnitOfWork uow = ((EntityStore)this.next).newUnitOfWork(usecase, module, currentTime);
        return new ConcurrentCheckingEntityStoreUnitOfWork(uow, (EntityStateVersions)this.api.dereference((Object)this.versions), module, currentTime);
    }

    private static class ConcurrentCheckingEntityStoreUnitOfWork
    implements EntityStoreUnitOfWork {
        private final EntityStoreUnitOfWork uow;
        private EntityStateVersions versions;
        private ModuleSpi module;
        private long currentTime;
        private List<EntityState> loaded = new ArrayList<EntityState>();
        private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        public ConcurrentCheckingEntityStoreUnitOfWork(EntityStoreUnitOfWork uow, EntityStateVersions versions, ModuleSpi module, long currentTime) {
            this.uow = uow;
            this.versions = versions;
            this.module = module;
            this.currentTime = currentTime;
        }

        @Override
        public String identity() {
            return this.uow.identity();
        }

        @Override
        public long currentTime() {
            return this.uow.currentTime();
        }

        @Override
        public EntityState newEntityState(ModuleSpi module, EntityReference anIdentity, EntityDescriptor entityDescriptor) throws EntityStoreException {
            return this.uow.newEntityState(module, anIdentity, entityDescriptor);
        }

        @Override
        public StateCommitter applyChanges() throws EntityStoreException {
            this.lock.writeLock().lock();
            try {
                this.versions.checkForConcurrentModification(this.loaded, this.module, this.currentTime);
                final StateCommitter committer = this.uow.applyChanges();
                return new StateCommitter(){

                    @Override
                    public void commit() {
                        committer.commit();
                        ConcurrentCheckingEntityStoreUnitOfWork.this.versions.forgetVersions(ConcurrentCheckingEntityStoreUnitOfWork.this.loaded);
                        ConcurrentCheckingEntityStoreUnitOfWork.this.lock.writeLock().unlock();
                    }

                    @Override
                    public void cancel() {
                        committer.cancel();
                        ConcurrentCheckingEntityStoreUnitOfWork.this.versions.forgetVersions(ConcurrentCheckingEntityStoreUnitOfWork.this.loaded);
                        ConcurrentCheckingEntityStoreUnitOfWork.this.lock.writeLock().unlock();
                    }
                };
            }
            catch (EntityStoreException e) {
                this.lock.writeLock().unlock();
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard() {
            try {
                this.uow.discard();
            }
            finally {
                this.lock.writeLock().lock();
                try {
                    this.versions.forgetVersions(this.loaded);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }

        @Override
        public Usecase usecase() {
            return this.uow.usecase();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EntityState entityStateOf(ModuleSpi module, EntityReference anIdentity) throws EntityStoreException, EntityNotFoundException {
            this.lock.readLock().lock();
            try {
                EntityState entityState = this.uow.entityStateOf(module, anIdentity);
                this.versions.rememberVersion(entityState.identity(), entityState.version());
                this.loaded.add(entityState);
                EntityState entityState2 = entityState;
                return entityState2;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }
}

