/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.util.Classes;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entity.NamedAssociationState;
import org.qi4j.spi.entitystore.helpers.DefaultManyAssociationState;
import org.qi4j.spi.entitystore.helpers.DefaultNamedAssociationState;

public final class DefaultEntityState
implements EntityState {
    private EntityStatus status;
    private String version;
    private long lastModified;
    private final EntityReference identity;
    private final EntityDescriptor entityDescriptor;
    private final Map<QualifiedName, Object> properties;
    private final Map<QualifiedName, EntityReference> associations;
    private final Map<QualifiedName, List<EntityReference>> manyAssociations;
    private final Map<QualifiedName, Map<String, EntityReference>> namedAssociations;

    public DefaultEntityState(long currentTime, EntityReference identity, EntityDescriptor entityDescriptor) {
        this("", currentTime, identity, EntityStatus.NEW, entityDescriptor, new HashMap<QualifiedName, Object>(), new HashMap<QualifiedName, EntityReference>(), new HashMap<QualifiedName, List<EntityReference>>(), new HashMap<QualifiedName, Map<String, EntityReference>>());
    }

    public DefaultEntityState(String version, long lastModified, EntityReference identity, EntityStatus status, EntityDescriptor entityDescriptor, Map<QualifiedName, Object> properties, Map<QualifiedName, EntityReference> associations, Map<QualifiedName, List<EntityReference>> manyAssociations, Map<QualifiedName, Map<String, EntityReference>> namedAssociations) {
        this.version = version;
        this.lastModified = lastModified;
        this.identity = identity;
        this.status = status;
        this.entityDescriptor = entityDescriptor;
        this.properties = properties;
        this.associations = associations;
        this.manyAssociations = manyAssociations;
        this.namedAssociations = namedAssociations;
    }

    @Override
    public final String version() {
        return this.version;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public EntityReference identity() {
        return this.identity;
    }

    @Override
    public Object propertyValueOf(QualifiedName stateName) {
        return this.properties.get(stateName);
    }

    @Override
    public void setPropertyValue(QualifiedName stateName, Object newValue) {
        this.properties.put(stateName, newValue);
        this.markUpdated();
    }

    @Override
    public EntityReference associationValueOf(QualifiedName stateName) {
        return this.associations.get(stateName);
    }

    @Override
    public void setAssociationValue(QualifiedName stateName, EntityReference newEntity) {
        this.associations.put(stateName, newEntity);
        this.markUpdated();
    }

    @Override
    public ManyAssociationState manyAssociationValueOf(QualifiedName stateName) {
        List<EntityReference> manyAssociationState = this.manyAssociations.get(stateName);
        if (manyAssociationState == null) {
            manyAssociationState = new ArrayList<EntityReference>();
            this.manyAssociations.put(stateName, manyAssociationState);
        }
        return new DefaultManyAssociationState(this, manyAssociationState);
    }

    @Override
    public NamedAssociationState namedAssociationValueOf(QualifiedName stateName) {
        Map<String, EntityReference> namedAssociationState = this.namedAssociations.get(stateName);
        if (namedAssociationState == null) {
            namedAssociationState = new LinkedHashMap<String, EntityReference>();
            this.namedAssociations.put(stateName, namedAssociationState);
        }
        return new DefaultNamedAssociationState(this, namedAssociationState);
    }

    public void copyTo(DefaultEntityState entityState) {
        entityState.properties.clear();
        for (Map.Entry<QualifiedName, Object> entry : this.properties.entrySet()) {
            entityState.properties.put(entry.getKey(), entry.getValue());
        }
        entityState.associations.clear();
        for (Map.Entry<QualifiedName, Object> entry : this.associations.entrySet()) {
            entityState.associations.put(entry.getKey(), (EntityReference)entry.getValue());
        }
        entityState.manyAssociations.clear();
        for (Map.Entry<QualifiedName, Object> entry : this.manyAssociations.entrySet()) {
            entityState.manyAssociations.put(entry.getKey(), (List<EntityReference>)entry.getValue());
        }
        entityState.namedAssociations.clear();
        for (Map.Entry<QualifiedName, Object> entry : this.namedAssociations.entrySet()) {
            entityState.namedAssociations.put(entry.getKey(), (Map<String, EntityReference>)entry.getValue());
        }
        entityState.version = this.version;
        entityState.lastModified = this.lastModified;
    }

    @Override
    public void remove() {
        this.status = EntityStatus.REMOVED;
    }

    @Override
    public EntityStatus status() {
        return this.status;
    }

    @Override
    public boolean isAssignableTo(Class<?> type) {
        return Classes.exactTypeSpecification(type).satisfiedBy((Object)this.entityDescriptor);
    }

    @Override
    public EntityDescriptor entityDescriptor() {
        return this.entityDescriptor;
    }

    public Map<QualifiedName, Object> properties() {
        return this.properties;
    }

    public Map<QualifiedName, EntityReference> associations() {
        return this.associations;
    }

    public Map<QualifiedName, List<EntityReference>> manyAssociations() {
        return this.manyAssociations;
    }

    public Map<QualifiedName, Map<String, EntityReference>> namedAssociations() {
        return this.namedAssociations;
    }

    public String toString() {
        return this.identity + "(" + this.properties.size() + " properties, " + this.associations.size() + " associations, " + this.manyAssociations.size() + " many-associations, " + this.namedAssociations.size() + " named-associations)";
    }

    public void markUpdated() {
        if (this.status == EntityStatus.LOADED) {
            this.status = EntityStatus.UPDATED;
        }
    }
}

