/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore.helpers;

import java.util.Iterator;
import java.util.Map;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.spi.entity.NamedAssociationState;
import org.qi4j.spi.entitystore.helpers.DefaultEntityState;

public final class DefaultNamedAssociationState
implements NamedAssociationState {
    private final DefaultEntityState entityState;
    private final Map<String, EntityReference> references;

    public DefaultNamedAssociationState(DefaultEntityState entityState, Map<String, EntityReference> references) {
        this.entityState = entityState;
        this.references = references;
    }

    @Override
    public int count() {
        return this.references.size();
    }

    @Override
    public boolean containsName(String name) {
        return this.references.containsKey(name);
    }

    @Override
    public boolean put(String name, EntityReference entityReference) {
        if (this.references.put(name, entityReference) == null) {
            return false;
        }
        this.entityState.markUpdated();
        return true;
    }

    @Override
    public boolean remove(String name) {
        if (this.references.remove(name) == null) {
            return false;
        }
        this.entityState.markUpdated();
        return true;
    }

    @Override
    public EntityReference get(String name) {
        return this.references.get(name);
    }

    @Override
    public String nameOf(EntityReference entityReference) {
        for (Map.Entry<String, EntityReference> entry : this.references.entrySet()) {
            if (!entry.getValue().equals((Object)entityReference)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator<String> iter = this.references.keySet().iterator();
        return new Iterator<String>(){
            private String current;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public String next() {
                this.current = (String)iter.next();
                return this.current;
            }

            @Override
            public void remove() {
                iter.remove();
                DefaultNamedAssociationState.this.entityState.markUpdated();
            }
        };
    }
}

