/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore.helpers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.JSONEntityState;

public final class JSONManyAssociationState
implements ManyAssociationState {
    private final JSONEntityState entityState;
    private final JSONArray references;

    public JSONManyAssociationState(JSONEntityState entityState, JSONArray references) {
        this.entityState = entityState;
        this.references = references;
    }

    @Override
    public int count() {
        return this.references.length();
    }

    @Override
    public boolean contains(EntityReference entityReference) {
        return this.indexOfReference(entityReference.identity()) != -1;
    }

    @Override
    public boolean add(int idx, EntityReference entityReference) {
        try {
            if (this.indexOfReference(entityReference.identity()) != -1) {
                return false;
            }
            this.entityState.cloneStateIfGlobalStateLoaded();
            this.insertReference(idx, entityReference.identity());
            this.entityState.markUpdated();
            return true;
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public boolean remove(EntityReference entityReference) {
        int refIndex = this.indexOfReference(entityReference.identity());
        if (refIndex != -1) {
            this.entityState.cloneStateIfGlobalStateLoaded();
            this.references.remove(refIndex);
            this.entityState.markUpdated();
            return true;
        }
        return false;
    }

    @Override
    public EntityReference get(int i) {
        try {
            return new EntityReference(this.references.getString(i));
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public Iterator<EntityReference> iterator() {
        return new Iterator<EntityReference>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < JSONManyAssociationState.this.references.length();
            }

            @Override
            public EntityReference next() {
                try {
                    EntityReference ref = new EntityReference(JSONManyAssociationState.this.references.getString(this.idx));
                    ++this.idx;
                    return ref;
                }
                catch (JSONException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() is not supported on ManyAssociation iterators.");
            }
        };
    }

    public String toString() {
        return this.references.toString();
    }

    private int indexOfReference(Object item) {
        for (int idx = 0; idx < this.references.length(); ++idx) {
            if (!item.equals(this.references.opt(idx))) continue;
            return idx;
        }
        return -1;
    }

    private void insertReference(int insert, Object item) throws JSONException {
        if (insert < 0 || insert > this.references.length()) {
            throw new JSONException("JSONArray[" + insert + "] is out of bounds.");
        }
        if (insert == this.references.length()) {
            this.references.put(item);
        } else {
            int idx;
            JSONArray output = new JSONArray();
            for (idx = 0; idx < this.references.length(); ++idx) {
                if (idx == insert) {
                    output.put(item);
                }
                output.put(this.references.opt(idx));
            }
            for (idx = 0; idx < output.length(); ++idx) {
                this.references.put(idx, output.opt(idx));
            }
        }
    }
}

