/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.spi.entitystore.helpers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.functional.Iterables;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entitystore.DefaultEntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.EntityStoreSPI;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.ModuleEntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateCommitter;
import org.qi4j.spi.entitystore.helpers.DefaultEntityState;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;
import org.qi4j.spi.entitystore.helpers.MapEntityStoreActivation;
import org.qi4j.spi.entitystore.helpers.Migration;
import org.qi4j.spi.entitystore.helpers.StateStore;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.module.ModuleSpi;

public class MapEntityStoreMixin
implements EntityStore,
EntityStoreSPI,
StateStore,
MapEntityStoreActivation {
    @This
    private MapEntityStore mapEntityStore;
    @This
    private EntityStoreSPI entityStoreSpi;
    @Structure
    private Qi4jSPI spi;
    @Structure
    private Application application;
    @Service
    @Tagged(value={"json"})
    private ValueSerialization valueSerialization;
    @Optional
    @Service
    private Migration migration;
    @Uses
    private ServiceDescriptor descriptor;
    protected String uuid;
    private int count;

    @Override
    public void activateMapEntityStore() throws Exception {
        this.uuid = UUID.randomUUID().toString() + "-";
    }

    @Override
    public EntityStoreUnitOfWork newUnitOfWork(Usecase usecaseMetaInfo, ModuleSpi module, long currentTime) {
        EntityStoreUnitOfWork storeUnitOfWork = new DefaultEntityStoreUnitOfWork(this.entityStoreSpi, this.newUnitOfWorkId(), usecaseMetaInfo, currentTime);
        storeUnitOfWork = new ModuleEntityStoreUnitOfWork(module, storeUnitOfWork);
        return storeUnitOfWork;
    }

    @Override
    public EntityState newEntityState(EntityStoreUnitOfWork unitOfWork, ModuleSpi module, EntityReference identity, EntityDescriptor entityDescriptor) {
        return new DefaultEntityState(unitOfWork.currentTime(), identity, entityDescriptor);
    }

    @Override
    public synchronized EntityState entityStateOf(EntityStoreUnitOfWork unitofwork, ModuleSpi module, EntityReference identity) {
        Reader in = this.mapEntityStore.get(identity);
        return this.readEntityState(module, in);
    }

    @Override
    public StateCommitter applyChanges(final EntityStoreUnitOfWork unitofwork, final Iterable<EntityState> state) throws EntityStoreException {
        return new StateCommitter(){

            @Override
            public void commit() {
                try {
                    MapEntityStoreMixin.this.mapEntityStore.applyChanges(new MapEntityStore.MapChanges(){

                        @Override
                        public void visitMap(MapEntityStore.MapChanger changer) throws IOException {
                            for (EntityState entityState : state) {
                                Throwable throwable;
                                Writer writer;
                                DefaultEntityState state = (DefaultEntityState)entityState;
                                if (state.status().equals((Object)EntityStatus.NEW)) {
                                    writer = changer.newEntity(state.identity(), state.entityDescriptor());
                                    throwable = null;
                                    try {
                                        MapEntityStoreMixin.this.writeEntityState(state, writer, unitofwork.identity(), unitofwork.currentTime());
                                        continue;
                                    }
                                    catch (Throwable x2) {
                                        throwable = x2;
                                        throw x2;
                                    }
                                    finally {
                                        if (writer == null) continue;
                                        if (throwable != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (Throwable x2) {
                                                throwable.addSuppressed(x2);
                                            }
                                            continue;
                                        }
                                        writer.close();
                                        continue;
                                    }
                                }
                                if (state.status().equals((Object)EntityStatus.UPDATED)) {
                                    writer = changer.updateEntity(state.identity(), state.entityDescriptor());
                                    throwable = null;
                                    try {
                                        MapEntityStoreMixin.this.writeEntityState(state, writer, unitofwork.identity(), unitofwork.currentTime());
                                        continue;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        if (writer == null) continue;
                                        if (throwable != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (Throwable x2) {
                                                throwable.addSuppressed(x2);
                                            }
                                            continue;
                                        }
                                        writer.close();
                                        continue;
                                    }
                                }
                                if (!state.status().equals((Object)EntityStatus.REMOVED)) continue;
                                changer.removeEntity(state.identity(), state.entityDescriptor());
                            }
                        }
                    });
                }
                catch (IOException e) {
                    throw new EntityStoreException(e);
                }
            }

            @Override
            public void cancel() {
            }
        };
    }

    @Override
    public Input<EntityState, EntityStoreException> entityStates(final ModuleSpi module) {
        return new Input<EntityState, EntityStoreException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super EntityState, ReceiverThrowableType> output) throws EntityStoreException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<EntityState, EntityStoreException>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super EntityState, ReceiverThrowableType> receiver) throws ReceiverThrowableType, EntityStoreException {
                        final ArrayList migrated = new ArrayList();
                        try {
                            MapEntityStoreMixin.this.mapEntityStore.entityStates().transferTo(new Output<Reader, ReceiverThrowableType>(){

                                public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends Reader, SenderThrowableType> sender) throws Throwable, Throwable {
                                    sender.sendTo(new Receiver<Reader, ReceiverThrowableType>(){

                                        public void receive(Reader item) throws Throwable {
                                            EntityState entity = MapEntityStoreMixin.this.readEntityState(module, item);
                                            if (entity.status() == EntityStatus.UPDATED) {
                                                migrated.add(entity);
                                                if (migrated.size() > 100) {
                                                    try {
                                                        MapEntityStoreMixin.this.synchMigratedEntities(migrated);
                                                    }
                                                    catch (IOException e) {
                                                        throw new EntityStoreException("Synchronization of Migrated Entities failed.", e);
                                                    }
                                                }
                                            }
                                            receiver.receive((Object)entity);
                                        }
                                    });
                                    if (!migrated.isEmpty()) {
                                        try {
                                            MapEntityStoreMixin.this.synchMigratedEntities(migrated);
                                        }
                                        catch (IOException e) {
                                            throw new EntityStoreException("Synchronization of Migrated Entities failed.", e);
                                        }
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            throw new EntityStoreException(e);
                        }
                    }
                });
            }
        };
    }

    private void synchMigratedEntities(final List<EntityState> migratedEntities) throws IOException {
        this.mapEntityStore.applyChanges(new MapEntityStore.MapChanges(){

            @Override
            public void visitMap(MapEntityStore.MapChanger changer) throws IOException {
                for (EntityState migratedEntity : migratedEntities) {
                    DefaultEntityState state = (DefaultEntityState)migratedEntity;
                    Writer writer = changer.updateEntity(state.identity(), state.entityDescriptor());
                    Throwable throwable = null;
                    try {
                        MapEntityStoreMixin.this.writeEntityState(state, writer, state.version(), state.lastModified());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
            }
        });
        migratedEntities.clear();
    }

    protected String newUnitOfWorkId() {
        return this.uuid + Integer.toHexString(this.count++);
    }

    protected void writeEntityState(DefaultEntityState state, Writer writer, String version, long lastModified) throws EntityStoreException {
        try {
            JSONWriter json = new JSONWriter(writer);
            JSONWriter properties = json.object().key("identity").value((Object)state.identity().identity()).key("application_version").value((Object)this.application.version()).key("type").value((Object)((Class)Iterables.first((Iterable)state.entityDescriptor().types())).getName()).key("version").value((Object)version).key("modified").value(lastModified).key("properties").object();
            EntityDescriptor entityType = state.entityDescriptor();
            for (PropertyDescriptor persistentProperty : entityType.state().properties()) {
                Object value = state.properties().get(persistentProperty.qualifiedName());
                json.key(persistentProperty.qualifiedName().name());
                if (value == null || ValueType.isPrimitiveValue((Object)value)) {
                    json.value(value);
                    continue;
                }
                String serialized = this.valueSerialization.serialize(value);
                if (serialized.startsWith("{")) {
                    json.value((Object)new JSONObject(serialized));
                    continue;
                }
                if (serialized.startsWith("[")) {
                    json.value((Object)new JSONArray(serialized));
                    continue;
                }
                json.value((Object)serialized);
            }
            JSONWriter associations = properties.endObject().key("associations").object();
            for (Map.Entry<QualifiedName, EntityReference> stateNameEntityReferenceEntry : state.associations().entrySet()) {
                EntityReference value = stateNameEntityReferenceEntry.getValue();
                associations.key(stateNameEntityReferenceEntry.getKey().name()).value((Object)(value != null ? value.identity() : null));
            }
            JSONWriter manyAssociations = associations.endObject().key("manyassociations").object();
            for (Map.Entry<QualifiedName, List<EntityReference>> stateNameListEntry : state.manyAssociations().entrySet()) {
                JSONWriter assocs = manyAssociations.key(stateNameListEntry.getKey().name()).array();
                for (EntityReference entityReference : stateNameListEntry.getValue()) {
                    assocs.value((Object)entityReference.identity());
                }
                assocs.endArray();
            }
            JSONWriter namedAssociations = manyAssociations.endObject().key("namedassociations").object();
            for (Map.Entry<QualifiedName, Map<String, EntityReference>> stateNameMapEntry : state.namedAssociations().entrySet()) {
                JSONWriter assocs = namedAssociations.key(stateNameMapEntry.getKey().name()).object();
                for (Map.Entry<String, EntityReference> namedRef : stateNameMapEntry.getValue().entrySet()) {
                    assocs.key(namedRef.getKey()).value((Object)namedRef.getValue().identity());
                }
                assocs.endObject();
            }
            namedAssociations.endObject().endObject();
        }
        catch (JSONException e) {
            throw new EntityStoreException("Could not store EntityState", e);
        }
    }

    protected EntityState readEntityState(ModuleSpi module, Reader entityState) throws EntityStoreException {
        try {
            String type;
            EntityDescriptor entityDescriptor;
            JSONObject jsonObject = new JSONObject(new JSONTokener(entityState));
            EntityStatus status = EntityStatus.LOADED;
            String version = jsonObject.getString("version");
            long modified = jsonObject.getLong("modified");
            String identity = jsonObject.getString("identity");
            String currentAppVersion = jsonObject.optString("application_version", "0.0");
            if (!currentAppVersion.equals(this.application.version())) {
                if (this.migration != null) {
                    this.migration.migrate(jsonObject, this.application.version(), this);
                } else {
                    jsonObject.put("application_version", (Object)this.application.version());
                }
                status = EntityStatus.UPDATED;
            }
            if ((entityDescriptor = module.entityDescriptor(type = jsonObject.getString("type"))) == null) {
                throw new EntityTypeNotFoundException(type, module.name(), Iterables.map(ModelModule.toStringFunction, module.findVisibleEntityTypes()));
            }
            HashMap<QualifiedName, Object> properties = new HashMap<QualifiedName, Object>();
            JSONObject props = jsonObject.getJSONObject("properties");
            for (PropertyDescriptor propertyDescriptor : entityDescriptor.state().properties()) {
                Object jsonValue;
                try {
                    jsonValue = props.get(propertyDescriptor.qualifiedName().name());
                }
                catch (JSONException e) {
                    Object initialValue = propertyDescriptor.initialValue((Module)module);
                    properties.put(propertyDescriptor.qualifiedName(), initialValue);
                    status = EntityStatus.UPDATED;
                    continue;
                }
                if (JSONObject.NULL.equals(jsonValue)) {
                    properties.put(propertyDescriptor.qualifiedName(), null);
                    continue;
                }
                Object value = this.valueSerialization.deserialize(propertyDescriptor.valueType(), jsonValue.toString());
                properties.put(propertyDescriptor.qualifiedName(), value);
            }
            HashMap<QualifiedName, EntityReference> associations = new HashMap<QualifiedName, EntityReference>();
            JSONObject assocs = jsonObject.getJSONObject("associations");
            for (AssociationDescriptor associationType : entityDescriptor.state().associations()) {
                try {
                    Object jsonValue = assocs.get(associationType.qualifiedName().name());
                    EntityReference value = jsonValue == JSONObject.NULL ? null : EntityReference.parseEntityReference((String)((String)jsonValue));
                    associations.put(associationType.qualifiedName(), value);
                }
                catch (JSONException e) {
                    associations.put(associationType.qualifiedName(), null);
                    status = EntityStatus.UPDATED;
                }
            }
            JSONObject manyAssocs = jsonObject.getJSONObject("manyassociations");
            HashMap<QualifiedName, List<EntityReference>> manyAssociations = new HashMap<QualifiedName, List<EntityReference>>();
            for (AssociationDescriptor manyAssociationType : entityDescriptor.state().manyAssociations()) {
                ArrayList<EntityReference> references = new ArrayList<EntityReference>();
                try {
                    JSONArray jsonValues = manyAssocs.getJSONArray(manyAssociationType.qualifiedName().name());
                    for (int i = 0; i < jsonValues.length(); ++i) {
                        String jsonValue = jsonValues.getString(i);
                        EntityReference value = jsonValue == JSONObject.NULL ? null : EntityReference.parseEntityReference((String)jsonValue);
                        references.add(value);
                    }
                    manyAssociations.put(manyAssociationType.qualifiedName(), references);
                }
                catch (JSONException e) {
                    manyAssociations.put(manyAssociationType.qualifiedName(), references);
                }
            }
            JSONObject namedAssocs = jsonObject.getJSONObject("namedassociations");
            HashMap<QualifiedName, Map<String, EntityReference>> namedAssociations = new HashMap<QualifiedName, Map<String, EntityReference>>();
            for (AssociationDescriptor namedAssociationType : entityDescriptor.state().namedAssociations()) {
                LinkedHashMap<String, EntityReference> references = new LinkedHashMap<String, EntityReference>();
                try {
                    JSONObject jsonValues = namedAssocs.getJSONObject(namedAssociationType.qualifiedName().name());
                    JSONArray names = jsonValues.names();
                    if (names != null) {
                        for (int idx = 0; idx < names.length(); ++idx) {
                            String name = names.getString(idx);
                            Object value = jsonValues.get(name);
                            EntityReference ref = value == JSONObject.NULL ? null : EntityReference.parseEntityReference((String)((String)value));
                            references.put(name, ref);
                        }
                    }
                    namedAssociations.put(namedAssociationType.qualifiedName(), references);
                }
                catch (JSONException e) {
                    namedAssociations.put(namedAssociationType.qualifiedName(), references);
                }
            }
            return new DefaultEntityState(version, modified, EntityReference.parseEntityReference((String)identity), status, entityDescriptor, properties, associations, manyAssociations, namedAssociations);
        }
        catch (JSONException e) {
            throw new EntityStoreException(e);
        }
    }

    @Override
    public JSONObject jsonStateOf(String id) throws IOException {
        JSONObject jsonObject;
        try (Reader reader = this.mapEntityStore.get(EntityReference.parseEntityReference((String)id));){
            jsonObject = new JSONObject(new JSONTokener(reader));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return jsonObject;
    }
}

